/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.tests.utils;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.keycloak.util.JsonSerialization;

public class JsonTestUtils {
    public static <T> void assertJsonEquals(T o1, T o2) {
        try {
            String o1Stripped = JsonSerialization.writeValueAsString(o1);
            String o2Stripped = JsonSerialization.writeValueAsString(o2);
            Assertions.assertEquals((Object)o1Stripped, (Object)o2Stripped);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void assertJsonEquals(String o1, Object o2) {
        try {
            Object o1Object = JsonSerialization.readValue((String)o1, o2.getClass());
            JsonTestUtils.assertJsonEquals(o1Object, o2);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void assertJsonEquals(String o1, String o2, Class<?> clazz) {
        try {
            Object o1Object = JsonSerialization.readValue((String)o1, clazz);
            Object o2Object = JsonSerialization.readValue((String)o2, clazz);
            JsonTestUtils.assertJsonEquals(o1Object, o2Object);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

