/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import org.keycloak.TokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.AsymmetricSignatureVerifierContext;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.ServerECDSASignatureVerifierContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.testsuite.util.oauth.KeyManager;

public class TokensManager {
    private final KeyManager keyManager;

    TokensManager(KeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public <T extends JsonWebToken> T verifyToken(String token, Class<T> clazz) {
        try {
            TokenVerifier verifier = TokenVerifier.create((String)token, clazz);
            String kid = verifier.getHeader().getKeyId();
            String algorithm = verifier.getHeader().getAlgorithm().name();
            KeyWrapper key = this.keyManager.getPublicKey(algorithm, kid);
            verifier.verifierContext((SignatureVerifierContext)(switch (algorithm) {
                case "ES256", "ES384", "ES512" -> new ServerECDSASignatureVerifierContext(key);
                default -> new AsymmetricSignatureVerifierContext(key);
            }));
            verifier.verify();
            return (T)verifier.getToken();
        }
        catch (VerificationException e) {
            throw new RuntimeException("Failed to decode token", e);
        }
    }

    public <T extends JsonWebToken> T parseToken(String token, Class<T> clazz) {
        try {
            return (T)((JsonWebToken)new JWSInput(token).readJsonContent(clazz));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

