/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

public class RefreshRequest
extends AbstractHttpPostRequest<RefreshRequest, AccessTokenResponse> {
    private final String refreshToken;

    RefreshRequest(String refreshToken, AbstractOAuthClient<?> client) {
        super(client);
        this.refreshToken = refreshToken;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    public RefreshRequest dpopProof(String dpopProof) {
        this.header("DPoP", dpopProof);
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "refresh_token");
        this.parameter("refresh_token", this.refreshToken);
        this.scope(false);
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

