/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

public class JWTAuthorizationGrantRequest
extends AbstractHttpPostRequest<JWTAuthorizationGrantRequest, AccessTokenResponse> {
    private String assertion;

    JWTAuthorizationGrantRequest(String assertion, AbstractOAuthClient<?> client) {
        super(client);
        this.assertion = assertion;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    public JWTAuthorizationGrantRequest assertion(String assertion) {
        this.assertion = assertion;
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        this.parameter("assertion", this.assertion);
        this.scope();
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

