/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.LogoutResponse;

public class LogoutRequest
extends AbstractHttpPostRequest<LogoutRequest, LogoutResponse> {
    private String refreshToken;
    private String idTokenHint;

    LogoutRequest(AbstractOAuthClient<?> client) {
        super(client);
    }

    public LogoutRequest refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public LogoutRequest idTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
        return this;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getLogout();
    }

    @Override
    protected void initRequest() {
        if (this.refreshToken != null) {
            this.parameter("refresh_token", this.refreshToken);
        }
        if (this.idTokenHint != null) {
            this.parameter("id_token_hint", this.idTokenHint);
        }
    }

    @Override
    protected LogoutResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new LogoutResponse(response);
    }
}

