/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth.ciba;

import java.io.IOException;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.ciba.AuthenticationRequestAcknowledgement;

public class BackchannelAuthenticationRequest
extends AbstractHttpPostRequest<BackchannelAuthenticationRequest, AuthenticationRequestAcknowledgement> {
    private final String userid;
    private String bindingMessage;
    private String acrValues;
    private String clientNotificationToken;
    private Map<String, String> additionalParams;

    BackchannelAuthenticationRequest(String userid, AbstractOAuthClient<?> client) {
        super(client);
        this.userid = userid;
    }

    public BackchannelAuthenticationRequest bindingMessage(String bindingMessage) {
        this.bindingMessage = bindingMessage;
        return this;
    }

    public BackchannelAuthenticationRequest acrValues(String acrValues) {
        this.acrValues = acrValues;
        return this;
    }

    public BackchannelAuthenticationRequest clientNotificationToken(String clientNotificationToken) {
        this.clientNotificationToken = clientNotificationToken;
        return this;
    }

    public BackchannelAuthenticationRequest additionalParams(Map<String, String> additionalParams) {
        this.additionalParams = additionalParams;
        return this;
    }

    public BackchannelAuthenticationRequest request(String request) {
        this.parameter("request", request);
        return this;
    }

    public BackchannelAuthenticationRequest requestUri(String requestUri) {
        this.parameter("request_uri", requestUri);
        return this;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getBackchannelAuthentication();
    }

    @Override
    protected void initRequest() {
        this.parameter("login_hint", this.userid);
        this.parameter("binding_message", this.bindingMessage);
        this.parameter("acr_values", this.acrValues);
        this.parameter("client_notification_token", this.clientNotificationToken);
        if (this.additionalParams != null) {
            this.additionalParams.forEach((x$0, x$1) -> this.parameter((String)x$0, (String)x$1));
        }
        this.scope();
    }

    @Override
    protected AuthenticationRequestAcknowledgement toResponse(CloseableHttpResponse response) throws IOException {
        return new AuthenticationRequestAcknowledgement(response);
    }
}

