/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.FederatedIdentityRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.testsuite.util.CredentialBuilder;
import org.keycloak.testsuite.util.FederatedIdentityBuilder;

public class AccountHelper {
    public static UserRepresentation getUserRepresentation(RealmResource realm, String username) {
        Optional userResult = realm.users().search(username, Boolean.valueOf(true)).stream().findFirst();
        if (userResult.isEmpty()) {
            throw new RuntimeException("User with username " + username + " not found");
        }
        return (UserRepresentation)userResult.get();
    }

    private static UserResource getUserResource(RealmResource realm, String username) {
        UserRepresentation userRepresentation = AccountHelper.getUserRepresentation(realm, username);
        return realm.users().get(userRepresentation.getId());
    }

    public static UserResource updateUser(RealmResource realm, String username, UserRepresentation userRepresentation) {
        AccountHelper.getUserResource(realm, username).update(userRepresentation);
        return AccountHelper.getUserResource(realm, username);
    }

    public static boolean updatePassword(RealmResource realm, String username, String password) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        CredentialRepresentation credentialRepresentation = CredentialBuilder.create().password(password).build();
        try {
            user.resetPassword(credentialRepresentation);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static List<Map<String, Object>> getUserConsents(RealmResource realm, String username) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        List consents = user.getConsents();
        return consents;
    }

    public static void revokeConsents(RealmResource realm, String username, String clientId) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        user.revokeConsent(clientId);
    }

    private static Optional<CredentialRepresentation> getOtpCredentials(UserResource user, String userLabel) {
        return user.credentials().stream().filter(c -> c.getType().equals("otp")).filter(l -> l.getUserLabel().equals(userLabel)).findFirst();
    }

    private static Optional<CredentialRepresentation> getOtpCredentials(UserResource user) {
        return user.credentials().stream().filter(c -> c.getType().equals("otp")).findFirst();
    }

    private static long getOtpCredentialsCount(UserResource user) {
        return user.credentials().stream().filter(c -> c.getType().equals("otp")).count();
    }

    public static boolean deleteTotpAuthentication(RealmResource realm, String username) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        Optional<CredentialRepresentation> credentials = AccountHelper.getOtpCredentials(user);
        if (credentials.isEmpty()) {
            return false;
        }
        try {
            user.removeCredential(credentials.get().getId());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isTotpPresent(RealmResource realm, String username) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        Optional<CredentialRepresentation> credentials = AccountHelper.getOtpCredentials(user);
        return credentials.isPresent();
    }

    public static boolean totpCountEquals(RealmResource realm, String username, int count) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        return (int)AccountHelper.getOtpCredentialsCount(user) == count;
    }

    public static boolean totpUserLabelComparator(RealmResource realm, String username, String userLabel) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        Optional<CredentialRepresentation> credentials = AccountHelper.getOtpCredentials(user, userLabel);
        return credentials.get().getUserLabel().equals(userLabel);
    }

    public static boolean updateTotpUserLabel(RealmResource realm, String username, String userLabel) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        Optional<CredentialRepresentation> credentials = AccountHelper.getOtpCredentials(user);
        try {
            user.setCredentialUserLabel(credentials.get().getId(), userLabel);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Response addIdentityProvider(RealmResource childRealm, String childUsername, RealmResource providerRealm, String providerUsername, String providerId) {
        UserResource user = AccountHelper.getUserResource(childRealm, childUsername);
        FederatedIdentityRepresentation identityRepresentation = FederatedIdentityBuilder.create().identityProvider(providerId).userId(AccountHelper.getUserResource(providerRealm, providerUsername).toRepresentation().getId()).userName(providerUsername).build();
        return user.addFederatedIdentity(providerId, identityRepresentation);
    }

    public static void deleteIdentityProvider(RealmResource realm, String username, String providerId) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        user.removeFederatedIdentity(providerId);
    }

    public static boolean isIdentityProviderLinked(RealmResource realm, String username, String providerId) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        for (FederatedIdentityRepresentation rep : user.getFederatedIdentity()) {
            if (!rep.getIdentityProvider().equals(providerId)) continue;
            return true;
        }
        return false;
    }

    public static void logout(RealmResource realm, String username) {
        UserResource user = AccountHelper.getUserResource(realm, username);
        user.logout();
    }
}

