/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import jakarta.ws.rs.core.UriBuilder;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.grants.ciba.CibaGrantType;
import org.keycloak.protocol.oidc.grants.device.DeviceGrantType;
import org.keycloak.protocol.oidc.par.endpoints.ParEndpoint;
import org.keycloak.services.resources.RealmsResource;

public class Endpoints {
    private final String baseUrl;
    private final String realm;

    public Endpoints(String baseUrl, String realm) {
        this.baseUrl = baseUrl;
        this.realm = realm;
    }

    public String getOpenIDConfiguration() {
        return this.asString(this.getBase().path(RealmsResource.class).path("{realm}/.well-known/openid-configuration"));
    }

    public String getAuthorization() {
        return this.asString(OIDCLoginProtocolService.authUrl((UriBuilder)this.getBase()));
    }

    public String getRegistration() {
        return this.asString(OIDCLoginProtocolService.registrationsUrl((UriBuilder)this.getBase()));
    }

    public String getToken() {
        return this.asString(OIDCLoginProtocolService.tokenUrl((UriBuilder)this.getBase()));
    }

    public String getIntrospection() {
        return this.asString(OIDCLoginProtocolService.tokenIntrospectionUrl((UriBuilder)this.getBase()));
    }

    public String getRevocation() {
        return this.asString(OIDCLoginProtocolService.tokenRevocationUrl((UriBuilder)this.getBase()));
    }

    public String getUserInfo() {
        return this.asString(OIDCLoginProtocolService.userInfoUrl((UriBuilder)this.getBase()));
    }

    public String getJwks() {
        return this.asString(OIDCLoginProtocolService.certsUrl((UriBuilder)this.getBase()));
    }

    public String getDeviceAuthorization() {
        return this.asString(DeviceGrantType.oauth2DeviceAuthUrl((UriBuilder)this.getBase()));
    }

    public String getPushedAuthorizationRequest() {
        return this.asString(ParEndpoint.parUrl((UriBuilder)this.getBase()));
    }

    public String getLogout() {
        return this.asString(OIDCLoginProtocolService.logoutUrl((UriBuilder)this.getBase()));
    }

    public String getBackChannelLogout() {
        return this.asString(OIDCLoginProtocolService.logoutUrl((UriBuilder)this.getBase()).path("/backchannel-logout"));
    }

    public String getBackchannelAuthentication() {
        return this.asString(CibaGrantType.authorizationUrl((UriBuilder)this.getBase()));
    }

    public String getBackchannelAuthenticationCallback() {
        return this.asString(CibaGrantType.authenticationUrl((UriBuilder)this.getBase()));
    }

    UriBuilder getBase() {
        return UriBuilder.fromUri((String)this.baseUrl);
    }

    String asString(UriBuilder b) {
        return b.build(new Object[]{this.realm}).toString();
    }
}

