/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.keycloak.testsuite.util.oauth.AbstractHttpPostRequest;
import org.keycloak.testsuite.util.oauth.AbstractOAuthClient;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;

public class TokenExchangeRequest
extends AbstractHttpPostRequest<TokenExchangeRequest, AccessTokenResponse> {
    private final String subjectToken;
    private final String subjectTokenType;
    private String requestedTokenType;
    private String requestedSubject;
    private List<String> audience;

    TokenExchangeRequest(String subjectToken, String subjectTokenType, AbstractOAuthClient<?> client) {
        super(client);
        this.subjectToken = subjectToken;
        this.subjectTokenType = subjectTokenType;
    }

    @Override
    protected String getEndpoint() {
        return this.client.getEndpoints().getToken();
    }

    public TokenExchangeRequest requestedTokenType(String requestedTokenType) {
        this.requestedTokenType = requestedTokenType;
        return this;
    }

    public TokenExchangeRequest requestedSubject(String requestedSubject) {
        this.requestedSubject = requestedSubject;
        return this;
    }

    public TokenExchangeRequest audience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public TokenExchangeRequest audience(String ... audience) {
        this.audience = Arrays.stream(audience).toList();
        return this;
    }

    @Override
    protected void initRequest() {
        this.parameter("grant_type", "urn:ietf:params:oauth:grant-type:token-exchange");
        this.parameter("subject_token", this.subjectToken);
        this.parameter("subject_token_type", this.subjectTokenType != null ? this.subjectTokenType : "urn:ietf:params:oauth:token-type:access_token");
        if (this.requestedTokenType != null) {
            this.parameter("requested_token_type", this.requestedTokenType);
        }
        if (this.requestedSubject != null) {
            this.parameter("requested_subject", this.requestedSubject);
        }
        if (this.audience != null) {
            this.audience.forEach(a -> this.parameter("audience", (String)a));
        }
        this.parameter("scope", this.client.config().getScope(false));
    }

    @Override
    protected AccessTokenResponse toResponse(CloseableHttpResponse response) throws IOException {
        return new AccessTokenResponse(response);
    }
}

