/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util.oauth;

import org.apache.http.impl.client.CloseableHttpClient;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AuthorizationResponseToken;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.testsuite.util.oauth.AccessTokenRequest;
import org.keycloak.testsuite.util.oauth.AccessTokenResponse;
import org.keycloak.testsuite.util.oauth.AuthorizationEndpointResponse;
import org.keycloak.testsuite.util.oauth.BackchannelLogoutRequest;
import org.keycloak.testsuite.util.oauth.BackchannelLogoutResponse;
import org.keycloak.testsuite.util.oauth.ClientCredentialsGrantRequest;
import org.keycloak.testsuite.util.oauth.Endpoints;
import org.keycloak.testsuite.util.oauth.HttpClientManager;
import org.keycloak.testsuite.util.oauth.IntrospectionRequest;
import org.keycloak.testsuite.util.oauth.IntrospectionResponse;
import org.keycloak.testsuite.util.oauth.KeyManager;
import org.keycloak.testsuite.util.oauth.LoginUrlBuilder;
import org.keycloak.testsuite.util.oauth.LogoutRequest;
import org.keycloak.testsuite.util.oauth.LogoutResponse;
import org.keycloak.testsuite.util.oauth.LogoutUrlBuilder;
import org.keycloak.testsuite.util.oauth.OAuthClientConfig;
import org.keycloak.testsuite.util.oauth.OpenIDProviderConfigurationRequest;
import org.keycloak.testsuite.util.oauth.OpenIDProviderConfigurationResponse;
import org.keycloak.testsuite.util.oauth.ParRequest;
import org.keycloak.testsuite.util.oauth.ParResponse;
import org.keycloak.testsuite.util.oauth.PasswordGrantRequest;
import org.keycloak.testsuite.util.oauth.RefreshRequest;
import org.keycloak.testsuite.util.oauth.RegistrationUrlBuilder;
import org.keycloak.testsuite.util.oauth.TokenExchangeRequest;
import org.keycloak.testsuite.util.oauth.TokenRevocationRequest;
import org.keycloak.testsuite.util.oauth.TokenRevocationResponse;
import org.keycloak.testsuite.util.oauth.TokensManager;
import org.keycloak.testsuite.util.oauth.UserInfoRequest;
import org.keycloak.testsuite.util.oauth.UserInfoResponse;
import org.keycloak.testsuite.util.oauth.ciba.CibaClient;
import org.keycloak.testsuite.util.oauth.device.DeviceClient;
import org.openqa.selenium.WebDriver;

public abstract class AbstractOAuthClient<T> {
    protected String baseUrl;
    protected OAuthClientConfig config;
    private final KeyManager keyManager = new KeyManager(this);
    private final TokensManager tokensManager = new TokensManager(this.keyManager);
    protected HttpClientManager httpClientManager;
    protected WebDriver driver;

    public AbstractOAuthClient(String baseUrl, CloseableHttpClient httpClient, WebDriver webDriver) {
        this.baseUrl = baseUrl;
        this.driver = webDriver;
        this.httpClientManager = new HttpClientManager(httpClient);
    }

    public T realm(String realm) {
        this.config.realm(realm);
        return this.client();
    }

    public T client(String clientId) {
        this.config.client(clientId);
        return this.client();
    }

    public T client(String clientId, String clientSecret) {
        this.config.client(clientId, clientSecret);
        return this.client();
    }

    public T redirectUri(String redirectUri) {
        this.config.redirectUri(redirectUri);
        return this.client();
    }

    public T scope(String scope) {
        this.config.scope(scope);
        return this.client();
    }

    public T openid(boolean openid) {
        this.config.openid(openid);
        return this.client();
    }

    public T responseType(String responseType) {
        this.config.responseType(responseType);
        return this.client();
    }

    public T responseMode(String responseMode) {
        this.config.responseMode(responseMode);
        return this.client();
    }

    public T origin(String origin) {
        this.config.origin(origin);
        return this.client();
    }

    public LoginUrlBuilder loginForm() {
        return new LoginUrlBuilder(this);
    }

    public void openLoginForm() {
        this.loginForm().open();
    }

    public AuthorizationEndpointResponse doLogin(String username, String password) {
        this.openLoginForm();
        this.fillLoginForm(username, password);
        return this.parseLoginResponse();
    }

    public abstract void fillLoginForm(String var1, String var2);

    public void openRegistrationForm() {
        this.driver.navigate().to(this.registrationForm().build());
    }

    public RegistrationUrlBuilder registrationForm() {
        return new RegistrationUrlBuilder(this);
    }

    public AuthorizationEndpointResponse parseLoginResponse() {
        return new AuthorizationEndpointResponse(this);
    }

    public PasswordGrantRequest passwordGrantRequest(String username, String password) {
        return new PasswordGrantRequest(username, password, this);
    }

    public AccessTokenResponse doPasswordGrantRequest(String username, String password) {
        return (AccessTokenResponse)this.passwordGrantRequest(username, password).send();
    }

    public AccessTokenRequest accessTokenRequest(String code) {
        return new AccessTokenRequest(code, this);
    }

    public AccessTokenResponse doAccessTokenRequest(String code) {
        return (AccessTokenResponse)this.accessTokenRequest(code).send();
    }

    public ClientCredentialsGrantRequest clientCredentialsGrantRequest() {
        return new ClientCredentialsGrantRequest(this);
    }

    public AccessTokenResponse doClientCredentialsGrantAccessTokenRequest() {
        return (AccessTokenResponse)this.clientCredentialsGrantRequest().send();
    }

    public RefreshRequest refreshRequest(String refreshToken) {
        return new RefreshRequest(refreshToken, this);
    }

    public AccessTokenResponse doRefreshTokenRequest(String refreshToken) {
        return (AccessTokenResponse)this.refreshRequest(refreshToken).send();
    }

    public LogoutUrlBuilder logoutForm() {
        return new LogoutUrlBuilder(this);
    }

    public void openLogoutForm() {
        this.logoutForm().open();
    }

    public LogoutRequest logoutRequest(String refreshToken) {
        return new LogoutRequest(refreshToken, this);
    }

    public LogoutResponse doLogout(String refreshToken) {
        return (LogoutResponse)this.logoutRequest(refreshToken).send();
    }

    public BackchannelLogoutRequest backchannelLogoutRequest(String logoutToken) {
        return new BackchannelLogoutRequest(logoutToken, this);
    }

    public BackchannelLogoutResponse doBackchannelLogout(String logoutToken) {
        return (BackchannelLogoutResponse)this.backchannelLogoutRequest(logoutToken).send();
    }

    public OpenIDProviderConfigurationRequest wellknownRequest() {
        return new OpenIDProviderConfigurationRequest(this);
    }

    public OIDCConfigurationRepresentation doWellKnownRequest() {
        return ((OpenIDProviderConfigurationResponse)this.wellknownRequest().send()).getOidcConfiguration();
    }

    public UserInfoRequest userInfoRequest(String accessToken) {
        return new UserInfoRequest(accessToken, this);
    }

    public UserInfoResponse doUserInfoRequest(String accessToken) {
        return (UserInfoResponse)this.userInfoRequest(accessToken).send();
    }

    public IntrospectionRequest introspectionRequest(String tokenToIntrospect) {
        return new IntrospectionRequest(tokenToIntrospect, this);
    }

    public IntrospectionResponse doIntrospectionRequest(String tokenToIntrospect, String tokenType) {
        return (IntrospectionResponse)this.introspectionRequest(tokenToIntrospect).tokenTypeHint(tokenType).send();
    }

    public IntrospectionResponse doIntrospectionAccessTokenRequest(String tokenToIntrospect) {
        return (IntrospectionResponse)this.introspectionRequest(tokenToIntrospect).tokenTypeHint("access_token").send();
    }

    public IntrospectionResponse doIntrospectionRefreshTokenRequest(String tokenToIntrospect) {
        return (IntrospectionResponse)this.introspectionRequest(tokenToIntrospect).tokenTypeHint("refresh_token").send();
    }

    public TokenRevocationRequest tokenRevocationRequest(String token) {
        return new TokenRevocationRequest(token, this);
    }

    public TokenRevocationResponse doTokenRevoke(String token) {
        return (TokenRevocationResponse)this.tokenRevocationRequest(token).send();
    }

    public TokenExchangeRequest tokenExchangeRequest(String subjectToken) {
        return this.tokenExchangeRequest(subjectToken, "urn:ietf:params:oauth:token-type:access_token");
    }

    public TokenExchangeRequest tokenExchangeRequest(String subjectToken, String subjectTokenType) {
        return new TokenExchangeRequest(subjectToken, subjectTokenType, this);
    }

    public AccessTokenResponse doTokenExchange(String subjectToken) {
        return (AccessTokenResponse)this.tokenExchangeRequest(subjectToken).send();
    }

    public CibaClient ciba() {
        return new CibaClient(this);
    }

    public DeviceClient device() {
        return new DeviceClient(this);
    }

    public ParRequest pushedAuthorizationRequest() {
        return new ParRequest(this);
    }

    public ParResponse doPushedAuthorizationRequest() {
        return (ParResponse)this.pushedAuthorizationRequest().send();
    }

    public <J extends JsonWebToken> J parseToken(String token, Class<J> clazz) {
        return this.tokensManager.parseToken(token, clazz);
    }

    public RefreshToken parseRefreshToken(String refreshToken) {
        return this.tokensManager.parseToken(refreshToken, RefreshToken.class);
    }

    public AccessToken verifyToken(String token) {
        return this.tokensManager.verifyToken(token, AccessToken.class);
    }

    public IDToken verifyIDToken(String token) {
        return this.tokensManager.verifyToken(token, IDToken.class);
    }

    public AuthorizationResponseToken verifyAuthorizationResponseToken(String token) {
        return this.tokensManager.verifyToken(token, AuthorizationResponseToken.class);
    }

    public <J extends JsonWebToken> J verifyToken(String token, Class<J> clazz) {
        return this.tokensManager.verifyToken(token, clazz);
    }

    public T baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this.client();
    }

    public OAuthClientConfig config() {
        return this.config;
    }

    public T driver(WebDriver webDriver) {
        this.driver = webDriver;
        return this.client();
    }

    public HttpClientManager httpClient() {
        return this.httpClientManager;
    }

    public KeyManager keys() {
        return this.keyManager;
    }

    public Endpoints getEndpoints() {
        return new Endpoints(this.baseUrl, this.config.getRealm());
    }

    public String getRealm() {
        return this.config.getRealm();
    }

    public String getClientId() {
        return this.config.getClientId();
    }

    public String getRedirectUri() {
        return this.config.getRedirectUri();
    }

    private T client() {
        return (T)this;
    }
}

