/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.idm.RoleRepresentation;

public class RoleBuilder {
    private final RoleRepresentation rep;

    public static RoleBuilder create() {
        return new RoleBuilder(new RoleRepresentation());
    }

    public static RoleBuilder edit(RoleRepresentation rep) {
        return new RoleBuilder(rep);
    }

    private RoleBuilder(RoleRepresentation rep) {
        this.rep = rep;
    }

    public RoleBuilder id(String id) {
        this.rep.setId(id);
        return this;
    }

    public RoleBuilder name(String name) {
        this.rep.setName(name);
        return this;
    }

    public RoleBuilder description(String description) {
        this.rep.setDescription(description);
        return this;
    }

    public RoleBuilder composite() {
        this.rep.setComposite(true);
        return this;
    }

    public RoleBuilder attributes(Map<String, List<String>> attributes) {
        this.rep.setAttributes(attributes);
        return this;
    }

    public RoleBuilder singleAttribute(String name, String value) {
        this.rep.singleAttribute(name, value);
        return this;
    }

    private void checkCompositesNull() {
        if (this.rep.getComposites() == null) {
            this.rep.setComposites(new RoleRepresentation.Composites());
        }
    }

    public RoleBuilder realmComposite(RoleRepresentation role) {
        return this.realmComposite(role.getName());
    }

    public RoleBuilder realmComposite(String compositeRole) {
        this.checkCompositesNull();
        if (this.rep.getComposites().getRealm() == null) {
            this.rep.getComposites().setRealm(new HashSet());
        }
        this.rep.getComposites().getRealm().add(compositeRole);
        return this;
    }

    public RoleBuilder clientComposite(String client, RoleRepresentation compositeRole) {
        return this.clientComposite(client, compositeRole.getName());
    }

    public RoleBuilder clientComposite(String client, String compositeRole) {
        this.checkCompositesNull();
        if (this.rep.getComposites().getClient() == null) {
            this.rep.getComposites().setClient(new HashMap());
        }
        if (this.rep.getComposites().getClient().get(client) == null) {
            this.rep.getComposites().getClient().put(client, new LinkedList());
        }
        ((List)this.rep.getComposites().getClient().get(client)).add(compositeRole);
        return this;
    }

    public RoleRepresentation build() {
        return this.rep;
    }
}

