/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.webdriver;

import java.time.Duration;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

class DriverOptions {
    DriverOptions() {
    }

    static ChromeOptions createChromeOptions(boolean headless) {
        ChromeOptions options = new ChromeOptions();
        DriverOptions.setCommonCapabilities((MutableCapabilities)options);
        if (headless) {
            options.addArguments(new String[]{"--headless=new", "--disable-gpu", "--window-size=1920,1200", "--ignore-certificate-errors", "--disable-dev-shm-usage", "--remote-allow-origins=*", "--no-sandbox"});
        }
        return options;
    }

    static FirefoxOptions createFirefoxOptions(boolean headless) {
        FirefoxOptions options = new FirefoxOptions();
        DriverOptions.setCommonCapabilities((MutableCapabilities)options);
        if (headless) {
            options.addArguments(new String[]{"-headless"});
        }
        options.addPreference("extensions.update.enabled", (Object)"false");
        options.addPreference("app.update.enabled", (Object)"false");
        options.addPreference("app.update.auto", (Object)"false");
        return options;
    }

    static DesiredCapabilities createHtmlUnitOptions() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        DriverOptions.setCommonCapabilities((MutableCapabilities)capabilities);
        capabilities.setBrowserName("htmlunit");
        capabilities.setCapability("downloadImages", false);
        capabilities.setCapability("javascriptEnabled", true);
        return capabilities;
    }

    private static void setCommonCapabilities(MutableCapabilities capabilities) {
        capabilities.setCapability("pageLoadStrategy", PageLoadStrategy.NORMAL.toString());
        capabilities.setCapability("timeouts", Map.of("implicit", Duration.ofSeconds(5L).toMillis()));
    }
}

