/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.keycloak.testframework.ui.page.AbstractLoginPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class OAuthGrantPage
extends AbstractLoginPage {
    public static final String PROFILE_CONSENT_TEXT = "User profile";
    public static final String EMAIL_CONSENT_TEXT = "Email address";
    public static final String ADDRESS_CONSENT_TEXT = "Address";
    public static final String PHONE_CONSENT_TEXT = "Phone number";
    public static final String OFFLINE_ACCESS_CONSENT_TEXT = "Offline Access";
    public static final String ROLES_CONSENT_TEXT = "User roles";
    @FindBy(css="[name=\"accept\"]")
    private WebElement acceptButton;
    @FindBy(css="[name=\"cancel\"]")
    private WebElement cancelButton;

    public OAuthGrantPage(ManagedWebDriver driver) {
        super(driver);
    }

    public void accept() {
        this.acceptButton.click();
    }

    public void cancel() {
        this.cancelButton.click();
    }

    public List<String> getDisplayedGrants() {
        ArrayList<String> table = new ArrayList<String>();
        WebElement divKcOauth = this.driver.findElement(By.id((String)"kc-oauth"));
        for (WebElement li : divKcOauth.findElements(By.tagName((String)"li"))) {
            WebElement span = li.findElement(By.tagName((String)"span"));
            table.add(span.getText());
        }
        return table;
    }

    public void assertGrants(String ... expectedGrants) {
        List<String> expected;
        List<String> displayed = this.getDisplayedGrants();
        Assertions.assertTrue((displayed.containsAll(expected = Arrays.asList(expectedGrants)) && expected.containsAll(displayed) ? 1 : 0) != 0, (String)("Not matched grants. Displayed grants: " + String.valueOf(displayed) + ", expected grants: " + String.valueOf(expected)));
    }

    @Override
    public String getExpectedPageId() {
        return "login-login-oauth-grant";
    }
}

