/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.webdriver;

import java.net.URL;
import org.keycloak.testframework.ui.webdriver.AssertionUtils;
import org.keycloak.testframework.ui.webdriver.BrowserType;
import org.keycloak.testframework.ui.webdriver.CookieUtils;
import org.keycloak.testframework.ui.webdriver.NavigateUtils;
import org.keycloak.testframework.ui.webdriver.PageUtils;
import org.keycloak.testframework.ui.webdriver.WaitUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class ManagedWebDriver {
    private WebDriver driver;
    private AssertionUtils assertionUtils = new AssertionUtils(this);
    private CookieUtils cookieUtils = new CookieUtils(this);
    private PageUtils pageUtils = new PageUtils(this);
    private NavigateUtils navigateUtils = new NavigateUtils(this);
    private WaitUtils waitUtils = new WaitUtils(this);

    public ManagedWebDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver driver() {
        return this.driver;
    }

    public BrowserType getBrowserType() {
        if (this.driver instanceof HtmlUnitDriver) {
            return BrowserType.HTML_UNIT;
        }
        if (this.driver instanceof ChromeDriver) {
            return BrowserType.CHROME;
        }
        if (this.driver instanceof FirefoxDriver) {
            return BrowserType.FIREFOX;
        }
        throw new RuntimeException("Unknown browser type: " + String.valueOf(this.driver.getClass()));
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public WebElement findElement(By by) {
        return this.driver.findElement(by);
    }

    public void open(String url) {
        this.driver.navigate().to(url);
    }

    public void open(URL url) {
        this.driver.navigate().to(url);
    }

    public AssertionUtils assertions() {
        return this.assertionUtils;
    }

    public CookieUtils cookies() {
        return this.cookieUtils;
    }

    public PageUtils page() {
        return this.pageUtils;
    }

    public NavigateUtils navigate() {
        return this.navigateUtils;
    }

    public WaitUtils waiting() {
        return this.waitUtils;
    }
}

