/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import java.util.Map;
import org.keycloak.testframework.ui.page.AbstractLoginPage;
import org.keycloak.testframework.ui.webdriver.ManagedWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class RegisterPage
extends AbstractLoginPage {
    @FindBy(name="firstName")
    private WebElement firstNameInput;
    @FindBy(name="lastName")
    private WebElement lastNameInput;
    @FindBy(name="email")
    private WebElement emailInput;
    @FindBy(name="username")
    private WebElement usernameInput;
    @FindBy(name="password")
    private WebElement passwordInput;
    @FindBy(name="password-confirm")
    private WebElement passwordConfirmInput;
    @FindBy(name="department")
    private WebElement departmentInput;
    @FindBy(name="termsAccepted")
    private WebElement termsAcceptedInput;
    @FindBy(css="input[type=\"submit\"]")
    private WebElement submitButton;

    public RegisterPage(ManagedWebDriver driver) {
        super(driver);
    }

    public void register(String firstName, String lastName, String email, String username, String password) {
        this.register(firstName, lastName, email, username, password, password, null, null, null);
    }

    public void register(String firstName, String lastName, String email, String username, String password, String passwordConfirm) {
        this.register(firstName, lastName, email, username, password, passwordConfirm, null, null, null);
    }

    public void register(String firstName, String lastName, String email, String username, String password, String passwordConfirm, String department, Boolean termsAccepted, Map<String, String> attributes) {
        this.firstNameInput.clear();
        if (firstName != null) {
            this.firstNameInput.sendKeys(new CharSequence[]{firstName});
        }
        this.lastNameInput.clear();
        if (lastName != null) {
            this.lastNameInput.sendKeys(new CharSequence[]{lastName});
        }
        if (email != null && this.isEmailPresent()) {
            this.emailInput.clear();
            this.emailInput.sendKeys(new CharSequence[]{email});
        }
        this.usernameInput.clear();
        if (username != null) {
            this.usernameInput.sendKeys(new CharSequence[]{username});
        }
        this.passwordInput.clear();
        if (password != null) {
            this.passwordInput.sendKeys(new CharSequence[]{password});
        }
        this.passwordConfirmInput.clear();
        if (passwordConfirm != null) {
            this.passwordConfirmInput.sendKeys(new CharSequence[]{passwordConfirm});
        }
        if (department != null && this.isDepartmentPresent()) {
            this.departmentInput.clear();
            this.departmentInput.sendKeys(new CharSequence[]{department});
        }
        if (termsAccepted != null && termsAccepted.booleanValue()) {
            this.termsAcceptedInput.click();
        }
        if (attributes != null) {
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                this.driver.findElement(By.name((String)("user.attributes." + attribute.getKey()))).sendKeys(new CharSequence[]{attribute.getValue()});
            }
        }
        this.submitButton.sendKeys(new CharSequence[]{Keys.ENTER});
    }

    public String getFirstName() {
        return this.firstNameInput.getAttribute("value");
    }

    public String getLastName() {
        return this.lastNameInput.getAttribute("value");
    }

    public String getEmail() {
        return this.emailInput.getAttribute("value");
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public String getPassword() {
        return this.passwordInput.getAttribute("value");
    }

    public boolean isDepartmentPresent() {
        try {
            return this.driver.findElement(By.name((String)"department")).isDisplayed();
        }
        catch (NoSuchElementException nse) {
            return false;
        }
    }

    public boolean isEmailPresent() {
        try {
            return this.driver.findElement(By.name((String)"email")).isDisplayed();
        }
        catch (NoSuchElementException nse) {
            return false;
        }
    }

    @Override
    public String getExpectedPageId() {
        return "login-register";
    }
}

