/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import org.keycloak.testframework.ui.page.AbstractPage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class LoginPage
extends AbstractPage {
    @FindBy(id="username")
    private WebElement usernameInput;
    @FindBy(id="password")
    private WebElement passwordInput;
    @FindBy(css="[type=submit]")
    private WebElement submitButton;

    public LoginPage(WebDriver driver) {
        super(driver);
    }

    public void fillLogin(String username, String password) {
        this.usernameInput.sendKeys(new CharSequence[]{username});
        this.passwordInput.sendKeys(new CharSequence[]{password});
    }

    public void submit() {
        this.submitButton.click();
    }

    @Override
    public String getExpectedPageId() {
        return "login-login";
    }

    public String getUsername() {
        return this.usernameInput.getAttribute("value");
    }

    public void clearUsernameInput() {
        this.usernameInput.clear();
    }
}

