/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.webdriver;

import java.time.Duration;
import java.util.Map;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.ui.annotations.InjectWebDriver;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;

public abstract class AbstractWebDriverSupplier
implements Supplier<WebDriver, InjectWebDriver> {
    public Class<InjectWebDriver> getAnnotationClass() {
        return InjectWebDriver.class;
    }

    public Class<WebDriver> getValueType() {
        return WebDriver.class;
    }

    public WebDriver getValue(InstanceContext<WebDriver, InjectWebDriver> instanceContext) {
        return this.getWebDriver();
    }

    public boolean compatible(InstanceContext<WebDriver, InjectWebDriver> a, RequestedInstance<WebDriver, InjectWebDriver> b) {
        return true;
    }

    public LifeCycle getDefaultLifecycle() {
        return LifeCycle.GLOBAL;
    }

    public void close(InstanceContext<WebDriver, InjectWebDriver> instanceContext) {
        ((WebDriver)instanceContext.getValue()).quit();
    }

    public abstract WebDriver getWebDriver();

    public void setCommonCapabilities(MutableCapabilities capabilities) {
        capabilities.setCapability("pageLoadStrategy", PageLoadStrategy.NORMAL.toString());
        capabilities.setCapability("timeouts", Map.of("implicit", Duration.ofSeconds(5L).toMillis()));
    }
}

