/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.ui.page;

import java.lang.reflect.Constructor;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.ui.annotations.InjectPage;
import org.keycloak.testframework.ui.page.AbstractPage;
import org.openqa.selenium.WebDriver;

public class PageSupplier
implements Supplier<AbstractPage, InjectPage> {
    public Class<InjectPage> getAnnotationClass() {
        return InjectPage.class;
    }

    public Class<AbstractPage> getValueType() {
        return AbstractPage.class;
    }

    public AbstractPage getValue(InstanceContext<AbstractPage, InjectPage> instanceContext) {
        WebDriver webDriver = (WebDriver)instanceContext.getDependency(WebDriver.class);
        return this.createPage(webDriver, instanceContext.getRequestedValueType());
    }

    public boolean compatible(InstanceContext<AbstractPage, InjectPage> a, RequestedInstance<AbstractPage, InjectPage> b) {
        return true;
    }

    private <S extends AbstractPage> S createPage(WebDriver webDriver, Class<S> valueType) {
        try {
            Constructor<S> constructor = valueType.getDeclaredConstructor(WebDriver.class);
            return (S)((AbstractPage)constructor.newInstance(webDriver));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

