/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.timeoffset;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.keycloak.common.util.Time;

public class TimeOffSet {
    private int currentOffset;
    private final String KEY_OFFSET = "offset";
    private final String TIME_OFFSET_ENDPOINT = "/testing-timeoffset";
    private final HttpClient httpClient;
    private final String serverUrl;

    public TimeOffSet(HttpClient httpClient, String serverUrl, int initOffset) {
        this.httpClient = httpClient;
        this.serverUrl = serverUrl;
        if (initOffset != 0) {
            this.set(initOffset);
        }
        this.currentOffset = initOffset;
    }

    public void set(int offset) throws RuntimeException {
        this.currentOffset = offset;
        Time.setOffset((int)this.currentOffset);
        Map<String, Integer> time = Map.of("offset", this.currentOffset);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString(time);
            HttpPut request = new HttpPut(this.serverUrl + "/testing-timeoffset");
            request.setEntity((HttpEntity)new StringEntity(json));
            request.setHeader("Content-type", "application/json");
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != Response.Status.OK.getStatusCode()) {
                StatusLine statusLine = response.getStatusLine();
                throw new WebApplicationException(String.format("Unexpected response status for TimeOffSet: %d %s", statusLine.getStatusCode(), statusLine.getReasonPhrase()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int get() {
        return this.currentOffset;
    }

    public boolean hasChanged() {
        return this.currentOffset != 0;
    }
}

