/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.runonserver;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.http.client.HttpClient;
import org.keycloak.testframework.injection.InstanceContext;
import org.keycloak.testframework.injection.LifeCycle;
import org.keycloak.testframework.injection.RequestedInstance;
import org.keycloak.testframework.injection.Supplier;
import org.keycloak.testframework.realm.ManagedRealm;
import org.keycloak.testframework.remote.RemoteProviders;
import org.keycloak.testframework.remote.runonserver.InjectRunOnServer;
import org.keycloak.testframework.remote.runonserver.RunOnServerClient;
import org.keycloak.testframework.remote.runonserver.TestClassServer;

public class RunOnServerSupplier
implements Supplier<RunOnServerClient, InjectRunOnServer> {
    public RunOnServerClient getValue(InstanceContext<RunOnServerClient, InjectRunOnServer> instanceContext) {
        HttpClient httpClient = (HttpClient)instanceContext.getDependency(HttpClient.class);
        ManagedRealm realm = (ManagedRealm)instanceContext.getDependency(ManagedRealm.class, ((InjectRunOnServer)instanceContext.getAnnotation()).realmRef());
        instanceContext.getDependency(RemoteProviders.class);
        TestClassServer testClassServer = (TestClassServer)instanceContext.getDependency(TestClassServer.class);
        String[] permittedPackages = ((InjectRunOnServer)instanceContext.getAnnotation()).permittedPackages();
        testClassServer.addPermittedPackages(new HashSet<String>(Arrays.asList(permittedPackages)));
        return new RunOnServerClient(httpClient, realm.getBaseUrl());
    }

    public boolean compatible(InstanceContext<RunOnServerClient, InjectRunOnServer> a, RequestedInstance<RunOnServerClient, InjectRunOnServer> b) {
        return ((InjectRunOnServer)a.getAnnotation()).realmRef().equals(((InjectRunOnServer)b.getAnnotation()).realmRef());
    }

    public LifeCycle getDefaultLifecycle() {
        return LifeCycle.METHOD;
    }

    public int order() {
        return 100;
    }
}

