/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.remote.providers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.services.resource.RealmResourceProvider;

public class TimeOffSetRealmResourceProvider
implements RealmResourceProvider {
    private final KeycloakSession session;
    private final String KEY_OFFSET = "offset";

    public TimeOffSetRealmResourceProvider(KeycloakSession session) {
        this.session = session;
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getTimeOffset() {
        int offset = Time.getOffset();
        Map<String, Integer> time = Map.of("offset", offset);
        return Response.ok(time).build();
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setTimeOffset(Map<String, Integer> time) {
        if (!time.containsKey("offset")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Time.setOffset((int)time.get("offset"));
        return Response.ok().header("Content-Type", (Object)"application/json").build();
    }
}

