/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testframework.mail;

import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.TokenValidator;
import com.icegreen.greenmail.user.UserImpl;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import jakarta.mail.internet.MimeMessage;
import org.keycloak.testframework.injection.ManagedTestResource;

public class MailServer
extends ManagedTestResource {
    private final GreenMail greenMail;

    public MailServer(String host, int port) {
        ServerSetup setup = new ServerSetup(port, host, "smtp");
        this.greenMail = new GreenMail(setup);
        this.greenMail.start();
    }

    public void stop() {
        this.greenMail.stop();
    }

    public void credentials(String username, String password) {
        this.greenMail.setUser(username, password);
    }

    public void credentials(String username, TokenValidator validator) {
        this.greenMail.setUser(username, null);
        GreenMailUser user = this.greenMail.getUserManager().getUser(username);
        ((UserImpl)user).setTokenValidator(validator);
    }

    public MimeMessage[] getReceivedMessages() {
        return this.greenMail.getReceivedMessages();
    }

    public MimeMessage getLastReceivedMessage() {
        MimeMessage[] receivedMessages = this.greenMail.getReceivedMessages();
        return receivedMessages != null && receivedMessages.length > 0 ? receivedMessages[receivedMessages.length - 1] : null;
    }

    public boolean waitForIncomingEmail(long timeout, int emailCount) {
        return this.greenMail.waitForIncomingEmail(timeout, emailCount);
    }

    public boolean waitForIncomingEmail(int emailCount) {
        return this.greenMail.waitForIncomingEmail(emailCount);
    }

    public void runCleanup() {
        try {
            this.greenMail.purgeEmailFromAllMailboxes();
        }
        catch (FolderException e) {
            throw new RuntimeException(e);
        }
    }
}

