/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.elytron.KeycloakHttpServerAuthenticationMechanismFactory;
import org.keycloak.subsystem.adapter.extension.KeycloakAdapterConfigService;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.util.SetMechanismInformationMechanismFactory;

public class KeycloakHttpAuthenticationFactoryService
implements Service<HttpServerAuthenticationMechanismFactory> {
    private final String factoryName;
    private HttpServerAuthenticationMechanismFactory httpAuthenticationFactory;

    public KeycloakHttpAuthenticationFactoryService(String factoryName) {
        this.factoryName = factoryName;
    }

    public void start(StartContext context) throws StartException {
        KeycloakAdapterConfigService adapterConfigService = KeycloakAdapterConfigService.getInstance();
        String config = adapterConfigService.getJSON(this.factoryName);
        this.httpAuthenticationFactory = new KeycloakHttpServerAuthenticationMechanismFactory(this.createDeploymentContext(config.getBytes()));
    }

    public void stop(StopContext context) {
        this.httpAuthenticationFactory = null;
    }

    public HttpServerAuthenticationMechanismFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return new SetMechanismInformationMechanismFactory(this.httpAuthenticationFactory);
    }

    private AdapterDeploymentContext createDeploymentContext(byte[] config) {
        return new AdapterDeploymentContext(KeycloakDeploymentBuilder.build((InputStream)new ByteArrayInputStream(config)));
    }
}

