/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.adapter.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.adapter.extension.SecureDeploymentDefinition;

public final class SecureDeploymentAddHandler
extends AbstractAddStepHandler {
    public static SecureDeploymentAddHandler INSTANCE = new SecureDeploymentAddHandler();

    private SecureDeploymentAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (!operation.get("operation").asString().equals("add")) {
            throw new OperationFailedException("Unexpected operation for add secure deployment. operation=" + operation.toString());
        }
        for (AttributeDefinition attributeDefinition : SecureDeploymentDefinition.ALL_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        KeycloakAdapterConfigService ckService = KeycloakAdapterConfigService.getInstance();
        ckService.addSecureDeployment(operation, context.resolveExpressions(model));
    }
}

