/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.adapter.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.adapter.extension.RealmDefinition;
import org.keycloak.subsystem.adapter.extension.SharedAttributeDefinitons;

public final class RealmAddHandler
extends AbstractAddStepHandler {
    public static RealmAddHandler INSTANCE = new RealmAddHandler();

    private RealmAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (!operation.get("operation").asString().equals("add")) {
            throw new OperationFailedException("Unexpected operation for add realm. operation=" + operation.toString());
        }
        for (AttributeDefinition attributeDefinition : RealmDefinition.ALL_ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
        if (!SharedAttributeDefinitons.validateTruststoreSetIfRequired(model.clone())) {
            throw new OperationFailedException("truststore and truststore-password must be set if ssl-required is not none and disable-trust-maanger is false.");
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        KeycloakAdapterConfigService ckService = KeycloakAdapterConfigService.getInstance();
        ckService.addRealm(operation, context.resolveExpressions(model));
    }
}

