/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.wf8.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.keycloak.subsystem.wf8.extension.CredentialDefinition;
import org.keycloak.subsystem.wf8.extension.KeycloakExtension;
import org.keycloak.subsystem.wf8.extension.RealmDefinition;
import org.keycloak.subsystem.wf8.extension.SecureDeploymentDefinition;
import org.keycloak.subsystem.wf8.extension.SharedAttributeDefinitons;

class KeycloakSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    KeycloakSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode addKeycloakSub = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{KeycloakExtension.PATH_SUBSYSTEM}));
        list.add(addKeycloakSub);
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            if (reader.getLocalName().equals("realm")) {
                this.readRealm(reader, list);
                continue;
            }
            if (!reader.getLocalName().equals("secure-deployment")) continue;
            this.readDeployment(reader, list);
        }
    }

    private int nextTag(XMLExtendedStreamReader reader) throws XMLStreamException {
        return reader.nextTag();
    }

    private void readRealm(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        String realmName = this.readNameAttribute(reader);
        ModelNode addRealm = new ModelNode();
        addRealm.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"keycloak"), PathElement.pathElement((String)"realm", (String)realmName)});
        addRealm.get("address").set(addr.toModelNode());
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            SimpleAttributeDefinition def = RealmDefinition.lookup(tagName);
            if (def == null) {
                throw new XMLStreamException("Unknown realm tag " + tagName);
            }
            def.parseAndSetParameter(reader.getElementText(), addRealm, (XMLStreamReader)reader);
        }
        if (!SharedAttributeDefinitons.validateTruststoreSetIfRequired(addRealm)) {
            throw new XMLStreamException("truststore and truststore-password must be set if ssl-required is not none and disable-trust-maanger is false.");
        }
        list.add(addRealm);
    }

    private void readDeployment(XMLExtendedStreamReader reader, List<ModelNode> resourcesToAdd) throws XMLStreamException {
        String name = this.readNameAttribute(reader);
        ModelNode addSecureDeployment = new ModelNode();
        addSecureDeployment.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"keycloak"), PathElement.pathElement((String)"secure-deployment", (String)name)});
        addSecureDeployment.get("address").set(addr.toModelNode());
        ArrayList<ModelNode> credentialsToAdd = new ArrayList<ModelNode>();
        while (reader.hasNext() && this.nextTag(reader) != 2) {
            String tagName = reader.getLocalName();
            if (tagName.equals("credential")) {
                this.readCredential(reader, addr, credentialsToAdd);
                continue;
            }
            SimpleAttributeDefinition def = SecureDeploymentDefinition.lookup(tagName);
            if (def == null) {
                throw new XMLStreamException("Unknown secure-deployment tag " + tagName);
            }
            def.parseAndSetParameter(reader.getElementText(), addSecureDeployment, (XMLStreamReader)reader);
        }
        resourcesToAdd.add(addSecureDeployment);
        resourcesToAdd.addAll(credentialsToAdd);
    }

    public void readCredential(XMLExtendedStreamReader reader, PathAddress parent, List<ModelNode> credentialsToAdd) throws XMLStreamException {
        String name = this.readNameAttribute(reader);
        HashMap<String, String> values = new HashMap<String, String>();
        String textValue = null;
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 4) {
                String text = reader.getText();
                if (text == null || text.trim().isEmpty()) continue;
                textValue = text;
                continue;
            }
            if (next == 1) {
                String key = reader.getLocalName();
                reader.next();
                String value = reader.getText();
                reader.next();
                values.put(key, value);
                continue;
            }
            if (next != 2) continue;
            break;
        }
        if (textValue != null) {
            ModelNode addCredential = this.getCredentialToAdd(parent, name, textValue);
            credentialsToAdd.add(addCredential);
        } else {
            for (Map.Entry entry : values.entrySet()) {
                ModelNode addCredential = this.getCredentialToAdd(parent, name + "." + (String)entry.getKey(), (String)entry.getValue());
                credentialsToAdd.add(addCredential);
            }
        }
    }

    private ModelNode getCredentialToAdd(PathAddress parent, String name, String value) {
        ModelNode addCredential = new ModelNode();
        addCredential.get("operation").set("add");
        PathAddress addr = PathAddress.pathAddress((PathAddress)parent, (PathElement[])new PathElement[]{PathElement.pathElement((String)"credential", (String)name)});
        addCredential.get("address").set(addr.toModelNode());
        addCredential.get(CredentialDefinition.VALUE.getName()).set(value);
        return addCredential;
    }

    private String readNameAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attr = reader.getAttributeLocalName(i);
            if (!attr.equals("name")) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            name = reader.getAttributeValue(i);
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        return name;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:jboss:domain:keycloak:1.1", false);
        this.writeRealms(writer, context);
        this.writeSecureDeployments(writer, context);
        writer.writeEndElement();
    }

    private void writeRealms(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().get("realm").isDefined()) {
            return;
        }
        for (Property realm : context.getModelNode().get("realm").asPropertyList()) {
            writer.writeStartElement("realm");
            writer.writeAttribute("name", realm.getName());
            ModelNode realmElements = realm.getValue();
            for (AttributeDefinition attributeDefinition : RealmDefinition.ALL_ATTRIBUTES) {
                attributeDefinition.marshallAsElement(realmElements, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }

    private void writeSecureDeployments(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        if (!context.getModelNode().get("secure-deployment").isDefined()) {
            return;
        }
        for (Property deployment : context.getModelNode().get("secure-deployment").asPropertyList()) {
            writer.writeStartElement("secure-deployment");
            writer.writeAttribute("name", deployment.getName());
            ModelNode deploymentElements = deployment.getValue();
            for (AttributeDefinition attributeDefinition : SecureDeploymentDefinition.ALL_ATTRIBUTES) {
                attributeDefinition.marshallAsElement(deploymentElements, (XMLStreamWriter)writer);
            }
            ModelNode credentials = deploymentElements.get("credential");
            if (credentials.isDefined()) {
                this.writeCredentials(writer, credentials);
            }
            writer.writeEndElement();
        }
    }

    private void writeCredentials(XMLExtendedStreamWriter writer, ModelNode credentials) throws XMLStreamException {
        LinkedHashMap<String, Object> parsed = new LinkedHashMap<String, Object>();
        for (Property property : credentials.asPropertyList()) {
            String credName = property.getName();
            String credValue = property.getValue().get(CredentialDefinition.VALUE.getName()).asString();
            if (credName.contains(".")) {
                String[] parts = credName.split("\\.");
                String provider = parts[0];
                String propKey = parts[1];
                LinkedHashMap<String, String> currentProviderMap = (LinkedHashMap<String, String>)parsed.get(provider);
                if (currentProviderMap == null) {
                    currentProviderMap = new LinkedHashMap<String, String>();
                    parsed.put(provider, currentProviderMap);
                }
                currentProviderMap.put(propKey, credValue);
                continue;
            }
            parsed.put(credName, credValue);
        }
        for (Map.Entry entry : parsed.entrySet()) {
            writer.writeStartElement("credential");
            writer.writeAttribute("name", (String)entry.getKey());
            Object value = entry.getValue();
            if (value instanceof String) {
                this.writeCharacters(writer, (String)value);
            } else {
                Map credentialProps = (Map)value;
                for (Map.Entry prop : credentialProps.entrySet()) {
                    writer.writeStartElement((String)prop.getKey());
                    this.writeCharacters(writer, (String)prop.getValue());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeCharacters(XMLExtendedStreamWriter writer, String content) throws XMLStreamException {
        if (content.indexOf(10) > -1) {
            writer.writeCharacters(content);
        } else {
            char[] chars = content.toCharArray();
            writer.writeCharacters(chars, 0, chars.length);
        }
    }
}

