/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.util.ldap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncryptionKey;

public class KerberosKeytabCreator {
    public static void main(String[] args) throws IOException {
        if (args == null || args.length != 3) {
            System.out.println("Kerberos keytab generator");
            System.out.println("-------------------------");
            System.out.println("Arguments missing or invalid. Required arguments are: <principalName> <passPhrase> <outputKeytabFile>");
            System.out.println("Example of usage:");
            System.out.println("java -jar embedded-ldap/target/embedded-ldap.jar keytabCreator HTTP/localhost@KEYCLOAK.ORG httppassword /tmp/http.keytab");
        } else {
            File keytabFile = new File(args[2]);
            KerberosKeytabCreator.createKeytab(args[0], args[1], keytabFile);
            System.out.println("Keytab file was created: " + keytabFile.getAbsolutePath() + ", principal: " + args[0] + ", passphrase: " + args[1]);
        }
    }

    public static void execute(String[] args, Properties defaultProperties) throws Exception {
        KerberosKeytabCreator.main(args);
    }

    public static void createKeytab(String principalName, String passPhrase, File keytabFile) throws IOException {
        KerberosTime timeStamp = new KerberosTime();
        boolean principalType = true;
        Keytab keytab = Keytab.getInstance();
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        for (Map.Entry keyEntry : KerberosKeyFactory.getKerberosKeys((String)principalName, (String)passPhrase).entrySet()) {
            System.out.println("Adding keytab entry of type: " + ((EncryptionType)keyEntry.getKey()).getName());
            EncryptionKey key = (EncryptionKey)keyEntry.getValue();
            byte keyVersion = (byte)key.getKeyVersion();
            entries.add(new KeytabEntry(principalName, 1, timeStamp, keyVersion, key));
        }
        keytab.setEntries(entries);
        keytab.write(keytabFile);
    }
}

