/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.events;

import java.util.HashMap;
import java.util.Map;
import org.keycloak.events.Event;
import org.keycloak.events.EventType;
import org.keycloak.test.framework.events.SysLog;

public class EventParser {
    private EventParser() {
    }

    public static Event parse(SysLog sysLog) {
        if (!sysLog.getCategory().equals("org.keycloak.events")) {
            return null;
        }
        String message = sysLog.getMessage().substring(sysLog.getMessage().indexOf(41) + 1).trim();
        if (!message.startsWith("type=")) {
            return null;
        }
        String[] split = message.split(", ");
        HashMap<String, String> eventMap = new HashMap<String, String>();
        for (String s : split) {
            String[] split1 = s.split("=");
            eventMap.put(split1[0], split1[1].substring(1, split1[1].length() - 1));
        }
        Event event = new Event();
        event.setTime(sysLog.getTimestamp().getTime() / 1000L);
        event.setDetails(new HashMap());
        block15: for (Map.Entry e : eventMap.entrySet()) {
            switch ((String)e.getKey()) {
                case "type": {
                    event.setType(EventType.valueOf((String)((String)e.getValue())));
                    continue block15;
                }
                case "clientId": {
                    event.setClientId((String)e.getValue());
                    continue block15;
                }
                case "realmId": {
                    event.setRealmId((String)e.getValue());
                    continue block15;
                }
                case "sessionId": {
                    event.setSessionId((String)e.getValue());
                    continue block15;
                }
                case "ipAddress": {
                    event.setIpAddress((String)e.getValue());
                }
            }
            event.getDetails().put((String)e.getKey(), (String)e.getValue());
        }
        return event;
    }
}

