/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.test.framework.realm;

import java.util.Optional;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class ManagedUser {
    private final UserRepresentation createdRepresentation;
    private final UserResource userResource;

    public ManagedUser(UserRepresentation createdRepresentation, UserResource userResource) {
        this.createdRepresentation = createdRepresentation;
        this.userResource = userResource;
    }

    public String getId() {
        return this.createdRepresentation.getId();
    }

    public String getUsername() {
        return this.createdRepresentation.getUsername();
    }

    public String getPassword() {
        Optional<CredentialRepresentation> password = this.createdRepresentation.getCredentials().stream().filter(c -> c.getType().equals("password")).findFirst();
        return password.map(CredentialRepresentation::getValue).orElse(null);
    }

    public UserResource admin() {
        return this.userResource;
    }
}

