/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigService;

public class KeycloakServerDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        KeycloakAdapterConfigService service = KeycloakAdapterConfigService.getInstance();
        if (!service.isKeycloakServerDeployment(deploymentName)) {
            return;
        }
        EEModuleDescription description = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        String webContext = service.getWebContext(deploymentName);
        if (webContext == null) {
            throw new DeploymentUnitProcessingException("Can't determine web context/module for Keycloak Auth Server");
        }
        description.setModuleName(webContext);
    }

    public void undeploy(DeploymentUnit du) {
    }
}

