/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension.authserver;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.extension.authserver.AuthServerDefinition;
import org.keycloak.subsystem.extension.authserver.AuthServerUtil;

public class AuthServerWriteAttributeHandler
extends ModelOnlyWriteAttributeHandler {
    public AuthServerWriteAttributeHandler(List<SimpleAttributeDefinition> definitions) {
        this(definitions.toArray(new AttributeDefinition[definitions.size()]));
    }

    public AuthServerWriteAttributeHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        if (!context.isNormalServer() || this.attribNotChanging(attributeName, newValue, oldValue)) {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            return;
        }
        boolean isEnabled = this.isEnabled(model);
        String deploymentName = AuthServerUtil.getDeploymentName(operation);
        if (attributeName.equals(AuthServerDefinition.WEB_CONTEXT.getName())) {
            KeycloakAdapterConfigService.getInstance().removeServerDeployment(deploymentName);
            KeycloakAdapterConfigService.getInstance().addServerDeployment(deploymentName, newValue.asString());
            if (isEnabled) {
                AuthServerUtil.addStepToRedeployAuthServer(context, deploymentName);
            }
        }
        if (attributeName.equals(AuthServerDefinition.ENABLED.getName())) {
            if (!isEnabled) {
                AuthServerUtil.addStepToUndeployAuthServer(context, deploymentName);
            } else {
                AuthServerUtil.addStepToDeployAuthServer(context, deploymentName);
            }
        }
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
    }

    private boolean isEnabled(Resource model) {
        ModelNode authServer = model.getModel();
        ModelNode isEnabled = authServer.get(AuthServerDefinition.ENABLED.getName());
        if (!isEnabled.isDefined()) {
            isEnabled = AuthServerDefinition.ENABLED.getDefaultValue();
        }
        return isEnabled.asBoolean();
    }

    private boolean attribNotChanging(String attributeName, ModelNode newValue, ModelNode oldValue) {
        SimpleAttributeDefinition attribDef = AuthServerDefinition.lookup(attributeName);
        if (!oldValue.isDefined()) {
            oldValue = attribDef.getDefaultValue();
        }
        if (!newValue.isDefined()) {
            newValue = attribDef.getDefaultValue();
        }
        return newValue.equals(oldValue);
    }
}

