/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SharedAttributeDefinitons {
    protected static final SimpleAttributeDefinition REALM_PUBLIC_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-public-key", ModelType.STRING, true).setXmlName("realm-public-key")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition AUTH_SERVER_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auth-server-url", ModelType.STRING, true).setXmlName("auth-server-url")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition SSL_REQUIRED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-required", ModelType.STRING, true).setXmlName("ssl-required")).setAllowExpression(true)).setDefaultValue(new ModelNode("external"))).build();
    protected static final SimpleAttributeDefinition ALLOW_ANY_HOSTNAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("allow-any-hostname", ModelType.BOOLEAN, true).setXmlName("allow-any-hostname")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition DISABLE_TRUST_MANAGER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("disable-trust-manager", ModelType.BOOLEAN, true).setXmlName("disable-trust-manager")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition TRUSTSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore", ModelType.STRING, true).setXmlName("truststore")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition TRUSTSTORE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("truststore-password", ModelType.STRING, true).setXmlName("truststore-password")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CONNECTION_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-pool-size", ModelType.INT, true).setXmlName("connection-pool-size")).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, true))).build();
    protected static final SimpleAttributeDefinition ENABLE_CORS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("enable-cors", ModelType.BOOLEAN, true).setXmlName("enable-cors")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEYSTORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-keystore", ModelType.STRING, true).setXmlName("client-keystore")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEYSTORE_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-keystore-password", ModelType.STRING, true).setXmlName("client-keystore-password")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CLIENT_KEY_PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("client-key-password", ModelType.STRING, true).setXmlName("client-key-password")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CORS_MAX_AGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cors-max-age", ModelType.INT, true).setXmlName("cors-max-age")).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    protected static final SimpleAttributeDefinition CORS_ALLOWED_HEADERS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cors-allowed-headers", ModelType.STRING, true).setXmlName("cors-allowed-headers")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition CORS_ALLOWED_METHODS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cors-allowed-methods", ModelType.STRING, true).setXmlName("cors-allowed-methods")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition EXPOSE_TOKEN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("expose-token", ModelType.BOOLEAN, true).setXmlName("expose-token")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition AUTH_SERVER_URL_FOR_BACKEND_REQUESTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("auth-server-url-for-backend-requests", ModelType.STRING, true).setXmlName("auth-server-url-for-backend-requests")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition ALWAYS_REFRESH_TOKEN = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("always-refresh-token", ModelType.BOOLEAN, true).setXmlName("always-refresh-token")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition REGISTER_NODE_AT_STARTUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("register-node-at-startup", ModelType.BOOLEAN, true).setXmlName("register-node-at-startup")).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).build();
    protected static final SimpleAttributeDefinition REGISTER_NODE_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("register-node-period", ModelType.INT, true).setXmlName("register-node-period")).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(-1, true))).build();
    protected static final SimpleAttributeDefinition TOKEN_STORE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("token-store", ModelType.STRING, true).setXmlName("token-store")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final SimpleAttributeDefinition PRINCIPAL_ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("principal-attribute", ModelType.STRING, true).setXmlName("principal-attribute")).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, true))).build();
    protected static final List<SimpleAttributeDefinition> ATTRIBUTES = new ArrayList<SimpleAttributeDefinition>();

    public static boolean validateTruststoreSetIfRequired(ModelNode attributes) {
        if (SharedAttributeDefinitons.isSet(attributes, DISABLE_TRUST_MANAGER)) {
            return true;
        }
        if (SharedAttributeDefinitons.isSet(attributes, SSL_REQUIRED) && attributes.get(SSL_REQUIRED.getName()).asString().equals("none")) {
            return true;
        }
        return SharedAttributeDefinitons.isSet(attributes, TRUSTSTORE) && SharedAttributeDefinitons.isSet(attributes, TRUSTSTORE_PASSWORD);
    }

    private static boolean isSet(ModelNode attributes, SimpleAttributeDefinition def) {
        ModelNode attribute = attributes.get(def.getName());
        if (def.getType() == ModelType.BOOLEAN) {
            return attribute.isDefined() && attribute.asBoolean();
        }
        return attribute.isDefined() && !attribute.asString().isEmpty();
    }

    static {
        ATTRIBUTES.add(REALM_PUBLIC_KEY);
        ATTRIBUTES.add(AUTH_SERVER_URL);
        ATTRIBUTES.add(TRUSTSTORE);
        ATTRIBUTES.add(TRUSTSTORE_PASSWORD);
        ATTRIBUTES.add(SSL_REQUIRED);
        ATTRIBUTES.add(ALLOW_ANY_HOSTNAME);
        ATTRIBUTES.add(DISABLE_TRUST_MANAGER);
        ATTRIBUTES.add(CONNECTION_POOL_SIZE);
        ATTRIBUTES.add(ENABLE_CORS);
        ATTRIBUTES.add(CLIENT_KEYSTORE);
        ATTRIBUTES.add(CLIENT_KEYSTORE_PASSWORD);
        ATTRIBUTES.add(CLIENT_KEY_PASSWORD);
        ATTRIBUTES.add(CORS_MAX_AGE);
        ATTRIBUTES.add(CORS_ALLOWED_HEADERS);
        ATTRIBUTES.add(CORS_ALLOWED_METHODS);
        ATTRIBUTES.add(EXPOSE_TOKEN);
        ATTRIBUTES.add(AUTH_SERVER_URL_FOR_BACKEND_REQUESTS);
        ATTRIBUTES.add(ALWAYS_REFRESH_TOKEN);
        ATTRIBUTES.add(REGISTER_NODE_AT_STARTUP);
        ATTRIBUTES.add(REGISTER_NODE_PERIOD);
        ATTRIBUTES.add(TOKEN_STORE);
        ATTRIBUTES.add(PRINCIPAL_ATTRIBUTE);
    }
}

