/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.extension;

import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.keycloak.subsystem.extension.Environment;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigDeploymentProcessor;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigDeploymentProcessorEAP6;
import org.keycloak.subsystem.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.extension.KeycloakDependencyProcessorEAP6;
import org.keycloak.subsystem.extension.KeycloakDependencyProcessorWildFly;
import org.keycloak.subsystem.extension.authserver.KeycloakServerDeploymentProcessor;

class KeycloakSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final KeycloakSubsystemAdd INSTANCE = new KeycloakSubsystemAdd();

    KeycloakSubsystemAdd() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        resource.getModel().setEmptyObject();
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("keycloak", Phase.DEPENDENCIES, 0, KeycloakSubsystemAdd.this.chooseDependencyProcessor());
                processorTarget.addDeploymentProcessor("keycloak", Phase.POST_MODULE, 2815, KeycloakSubsystemAdd.this.chooseConfigDeploymentProcessor());
                processorTarget.addDeploymentProcessor("keycloak", Phase.POST_MODULE, 2815, (DeploymentUnitProcessor)new KeycloakServerDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
    }

    private DeploymentUnitProcessor chooseDependencyProcessor() {
        if (Environment.isWildFly()) {
            return new KeycloakDependencyProcessorWildFly();
        }
        return new KeycloakDependencyProcessorEAP6();
    }

    private DeploymentUnitProcessor chooseConfigDeploymentProcessor() {
        if (Environment.isWildFly()) {
            return new KeycloakAdapterConfigDeploymentProcessor();
        }
        return new KeycloakAdapterConfigDeploymentProcessorEAP6();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        super.performRuntime(context, operation, model, verificationHandler, newControllers);
        ServiceController controller = context.getServiceTarget().addService(KeycloakAdapterConfigService.SERVICE_NAME, (Service)KeycloakAdapterConfigService.INSTANCE).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        newControllers.add(controller);
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

