/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import java.security.Principal;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.springsecurity.account.SimpleKeycloakAccount;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringSecurityRequestAuthenticator
extends RequestAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(SpringSecurityRequestAuthenticator.class);
    private final HttpServletRequest request;

    public SpringSecurityRequestAuthenticator(HttpFacade facade, HttpServletRequest request, KeycloakDeployment deployment, AdapterTokenStore tokenStore, int sslRedirectPort) {
        super(facade, deployment, tokenStore, sslRedirectPort);
        this.request = request;
    }

    protected OAuthRequestAuthenticator createOAuthAuthenticator() {
        return new OAuthRequestAuthenticator((RequestAuthenticator)this, this.facade, this.deployment, this.sslRedirectPort, (AdapterSessionStore)this.tokenStore);
    }

    protected void completeOAuthAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        SimpleKeycloakAccount account = new SimpleKeycloakAccount((Principal)principal, roles, securityContext);
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
        this.tokenStore.saveAccountInfo((OidcKeycloakAccount)account);
    }

    protected void completeBearerAuthentication(KeycloakPrincipal<RefreshableKeycloakSecurityContext> principal, String method) {
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        SimpleKeycloakAccount account = new SimpleKeycloakAccount((Principal)principal, roles, securityContext);
        logger.debug("Completing bearer authentication. Bearer roles: {} ", (Object)roles);
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication((Authentication)new KeycloakAuthenticationToken((KeycloakAccount)account, false));
        SecurityContextHolder.setContext((SecurityContext)context);
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)securityContext);
    }

    protected String changeHttpSessionId(boolean create) {
        HttpSession session = this.request.getSession(create);
        return session != null ? session.getId() : null;
    }
}

