/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.KeycloakAuthenticationException;
import org.keycloak.adapters.springsecurity.authentication.SpringSecurityRequestAuthenticator;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.keycloak.adapters.springsecurity.token.AdapterTokenStoreFactory;
import org.keycloak.adapters.springsecurity.token.SpringSecurityAdapterTokenStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public class KeycloakAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter
implements ApplicationContextAware {
    public static final String DEFAULT_LOGIN_URL = "/sso/login";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final RequestMatcher DEFAULT_REQUEST_MATCHER = new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher("/sso/login"), new RequestHeaderRequestMatcher("Authorization")});
    private static final Logger log = LoggerFactory.getLogger(KeycloakAuthenticationProcessingFilter.class);
    private ApplicationContext applicationContext;
    private AdapterDeploymentContext adapterDeploymentContext;
    private AdapterTokenStoreFactory adapterTokenStoreFactory = new SpringSecurityAdapterTokenStoreFactory();
    private AuthenticationManager authenticationManager;

    public KeycloakAuthenticationProcessingFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, DEFAULT_REQUEST_MATCHER);
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler(DEFAULT_LOGIN_URL));
    }

    public KeycloakAuthenticationProcessingFilter(AuthenticationManager authenticationManager, RequestMatcher requiresAuthenticationRequestMatcher) {
        super(requiresAuthenticationRequestMatcher);
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.authenticationManager = authenticationManager;
        super.setAuthenticationManager(authenticationManager);
        super.setAllowSessionCreation(false);
        super.setContinueChainBeforeSuccessfulAuthentication(false);
    }

    public void afterPropertiesSet() {
        this.adapterDeploymentContext = (AdapterDeploymentContext)this.applicationContext.getBean(AdapterDeploymentContext.class);
        super.afterPropertiesSet();
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        log.debug("Attempting Keycloak authentication");
        SimpleHttpFacade facade = new SimpleHttpFacade(request, response);
        KeycloakDeployment deployment = this.adapterDeploymentContext.resolveDeployment((HttpFacade)facade);
        AdapterTokenStore tokenStore = this.adapterTokenStoreFactory.createAdapterTokenStore(deployment, request);
        SpringSecurityRequestAuthenticator authenticator = new SpringSecurityRequestAuthenticator((HttpFacade)facade, request, deployment, tokenStore, -1);
        AuthOutcome result = authenticator.authenticate();
        log.debug("Auth outcome: {}", (Object)result);
        if (AuthOutcome.FAILED.equals((Object)result)) {
            throw new KeycloakAuthenticationException("Auth outcome: " + result);
        }
        if (AuthOutcome.AUTHENTICATED.equals((Object)result)) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Assert.notNull((Object)authentication, (String)"Authentication SecurityContextHolder was null");
            return this.authenticationManager.authenticate(authentication);
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        return null;
    }

    protected boolean isBearerTokenRequest(HttpServletRequest request) {
        String authValue = request.getHeader(AUTHORIZATION_HEADER);
        return authValue != null && authValue.startsWith("Bearer");
    }

    protected boolean isBasicAuthRequest(HttpServletRequest request) {
        String authValue = request.getHeader(AUTHORIZATION_HEADER);
        return authValue != null && authValue.startsWith("Basic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        if (!this.isBearerTokenRequest(request) && !this.isBasicAuthRequest(request)) {
            super.successfulAuthentication(request, response, chain, authResult);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Authentication success using bearer token/basic authentication. Updating SecurityContextHolder to contain: {}", (Object)authResult);
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, ((Object)((Object)this)).getClass()));
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        if (this.isBearerTokenRequest(request)) {
            SecurityContextHolder.clearContext();
            response.sendError(401, "Unable to authenticate bearer token");
            return;
        }
        if (this.isBasicAuthRequest(request)) {
            SecurityContextHolder.clearContext();
            response.sendError(401, "Unable to authenticate with basic authentication");
            return;
        }
        super.unsuccessfulAuthentication(request, response, failed);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAdapterTokenStoreFactory(AdapterTokenStoreFactory adapterTokenStoreFactory) {
        Assert.notNull((Object)adapterTokenStoreFactory, (String)"AdapterTokenStoreFactory cannot be null");
        this.adapterTokenStoreFactory = adapterTokenStoreFactory;
    }

    public final void setAllowSessionCreation(boolean allowSessionCreation) {
        throw new UnsupportedOperationException("This filter does not support explicitly setting a session creation policy");
    }

    public final void setContinueChainBeforeSuccessfulAuthentication(boolean continueChainBeforeSuccessfulAuthentication) {
        throw new UnsupportedOperationException("This filter does not support explicitly setting a continue chain before success policy");
    }
}

