/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class HttpHeaderInspectingApiRequestMatcher
implements RequestMatcher {
    protected static final String X_REQUESTED_WITH_HEADER = "X-Requested-With";
    protected static final String X_REQUESTED_WITH_HEADER_AJAX_VALUE = "XMLHttpRequest";

    public boolean matches(HttpServletRequest request) {
        boolean ajax = X_REQUESTED_WITH_HEADER_AJAX_VALUE.equals(request.getHeader(X_REQUESTED_WITH_HEADER));
        boolean html = request.getHeader("Accept") != null && request.getHeader("Accept").contains("text/html");
        return ajax || !html;
    }
}

