/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.AdapterDeploymentContextBean;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.util.Assert;

public class KeycloakLogoutHandler
implements LogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(KeycloakLogoutHandler.class);
    private AdapterDeploymentContextBean deploymentContextBean;

    public KeycloakLogoutHandler(AdapterDeploymentContextBean deploymentContextBean) {
        Assert.notNull((Object)deploymentContextBean);
        this.deploymentContextBean = deploymentContextBean;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (authentication == null) {
            log.warn("Cannot log out without authentication");
            return;
        }
        if (!KeycloakAuthenticationToken.class.isAssignableFrom(authentication.getClass())) {
            log.warn("Cannot log out a non-Keycloak authentication: {}", (Object)authentication);
            return;
        }
        this.handleSingleSignOut(request, response, (KeycloakAuthenticationToken)authentication);
    }

    protected void handleSingleSignOut(HttpServletRequest request, HttpServletResponse response, KeycloakAuthenticationToken authenticationToken) {
        KeycloakDeployment deployment = this.deploymentContextBean.getDeployment();
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)authenticationToken.getAccount().getKeycloakSecurityContext();
        session.logout(deployment);
    }
}

