/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class AdapterDeploymentContextBean
implements ApplicationContextAware,
InitializingBean {
    private static final String KEYCLOAK_CONFIG_FILE = "keycloak.json";
    private static final String KEYCLOAK_CONFIG_WEB_RESOURCE = "WEB-INF/keycloak.json";
    private static final String KEYCLOAK_CONFIG_CLASSPATH_RESOURCE = "classpath:keycloak.json";
    private ApplicationContext applicationContext;
    private AdapterDeploymentContext deploymentContext;
    private KeycloakDeployment deployment;

    public void afterPropertiesSet() throws Exception {
        this.deployment = this.loadKeycloakDeployment();
        this.deploymentContext = new AdapterDeploymentContext(this.deployment);
    }

    private KeycloakDeployment loadKeycloakDeployment() throws IOException {
        Resource resource = this.applicationContext.getResource(KEYCLOAK_CONFIG_WEB_RESOURCE);
        if (!resource.isReadable()) {
            resource = this.applicationContext.getResource(KEYCLOAK_CONFIG_CLASSPATH_RESOURCE);
        }
        if (!resource.isReadable()) {
            throw new FileNotFoundException(String.format("Unable to locate Keycloak from %s or %s", KEYCLOAK_CONFIG_WEB_RESOURCE, KEYCLOAK_CONFIG_CLASSPATH_RESOURCE));
        }
        return KeycloakDeploymentBuilder.build((InputStream)resource.getInputStream());
    }

    public AdapterDeploymentContext getDeploymentContext() {
        return this.deploymentContext;
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

