/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.token;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakAccount;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class SpringSecurityTokenStore
implements AdapterTokenStore {
    private final Logger logger = LoggerFactory.getLogger(SpringSecurityTokenStore.class);
    private final KeycloakDeployment deployment;
    private final HttpServletRequest request;

    public SpringSecurityTokenStore(KeycloakDeployment deployment, HttpServletRequest request) {
        Assert.notNull((Object)deployment, (String)"KeycloakDeployment is required");
        Assert.notNull((Object)request, (String)"HttpServletRequest is required");
        this.deployment = deployment;
        this.request = request;
    }

    public void checkCurrentToken() {
    }

    public boolean isCached(RequestAuthenticator authenticator) {
        this.logger.debug("Checking if {} is cached", (Object)authenticator);
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null || context.getAuthentication() == null) {
            return false;
        }
        if (!KeycloakAuthenticationToken.class.isAssignableFrom(context.getAuthentication().getClass())) {
            this.logger.warn("Expected a KeycloakAuthenticationToken, but found {}", (Object)context.getAuthentication());
            return false;
        }
        this.logger.info("Remote logged in already. Establishing state from security context.");
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)context.getAuthentication();
        KeycloakSecurityContext keycloakSecurityContext = token.getAccount().getKeycloakSecurityContext();
        if (!this.deployment.getRealm().equals(keycloakSecurityContext.getRealm())) {
            this.logger.info("Account from security context is from a different realm than for the request.");
            this.logout();
            return false;
        }
        if (keycloakSecurityContext.getToken().isExpired()) {
            this.logger.warn("Security token expired ... not returning from cache");
            return false;
        }
        this.request.setAttribute(KeycloakSecurityContext.class.getName(), (Object)keycloakSecurityContext);
        return true;
    }

    public void saveAccountInfo(KeycloakAccount account) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            throw new IllegalStateException(String.format("Went to save Keycloak account %s, but already have %s", account, authentication));
        }
        this.logger.debug("Saving account info {}", (Object)account);
        SecurityContextHolder.getContext().setAuthentication((Authentication)new KeycloakAuthenticationToken(account));
    }

    public void logout() {
        this.logger.debug("Handling logout request");
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.setAttribute(KeycloakSecurityContext.class.getName(), null);
            session.invalidate();
        }
        SecurityContextHolder.clearContext();
    }

    public void refreshCallback(RefreshableKeycloakSecurityContext securityContext) {
    }

    public void saveRequest() {
    }

    public boolean restoreRequest() {
        return false;
    }
}

