/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.UserSessionManagement;
import org.keycloak.adapters.springsecurity.AdapterDeploymentContextBean;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.filter.GenericFilterBean;

public class KeycloakPreAuthActionsFilter
extends GenericFilterBean
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(KeycloakPreAuthActionsFilter.class);
    private ApplicationContext applicationContext;
    private AdapterDeploymentContext deploymentContext;
    private UserSessionManagement userSessionManagement;

    public KeycloakPreAuthActionsFilter() {
    }

    public KeycloakPreAuthActionsFilter(UserSessionManagement userSessionManagement) {
        this.userSessionManagement = userSessionManagement;
    }

    protected void initFilterBean() throws ServletException {
        AdapterDeploymentContextBean contextBean = (AdapterDeploymentContextBean)this.applicationContext.getBean(AdapterDeploymentContextBean.class);
        this.deploymentContext = contextBean.getDeploymentContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SimpleHttpFacade facade = new SimpleHttpFacade((HttpServletRequest)request, (HttpServletResponse)response);
        PreAuthActionsHandler handler = new PreAuthActionsHandler(this.userSessionManagement, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            log.info("Pre-auth filter handled request: {}", (Object)((HttpServletRequest)request).getRequestURI());
        } else {
            chain.doFilter(request, response);
        }
    }

    public void setUserSessionManagement(UserSessionManagement userSessionManagement) {
        this.userSessionManagement = userSessionManagement;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

