/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.config;

import javax.servlet.Filter;
import org.keycloak.adapters.springsecurity.AdapterDeploymentContextBean;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationEntryPoint;
import org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationProvider;
import org.keycloak.adapters.springsecurity.authentication.KeycloakLogoutHandler;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticationProcessingFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakPreAuthActionsFilter;
import org.keycloak.adapters.springsecurity.management.HttpSessionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

public abstract class KeycloakWebSecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter
implements WebSecurityConfigurer<WebSecurity> {
    @Bean
    protected AdapterDeploymentContextBean adapterDeploymentContextBean() {
        return new AdapterDeploymentContextBean();
    }

    @Bean
    protected AuthenticationEntryPoint authenticationEntryPoint() {
        return new KeycloakAuthenticationEntryPoint();
    }

    @Bean
    protected KeycloakAuthenticationProvider keycloakAuthenticationProvider() {
        return new KeycloakAuthenticationProvider();
    }

    @Bean
    protected KeycloakAuthenticationProcessingFilter keycloakAuthenticationProcessingFilter() throws Exception {
        KeycloakAuthenticationProcessingFilter filter = new KeycloakAuthenticationProcessingFilter(this.authenticationManagerBean());
        filter.setSessionAuthenticationStrategy(this.sessionAuthenticationStrategy());
        return filter;
    }

    @Bean
    protected KeycloakPreAuthActionsFilter keycloakPreAuthActionsFilter() {
        return new KeycloakPreAuthActionsFilter(this.httpSessionManager());
    }

    @Bean
    protected HttpSessionManager httpSessionManager() {
        return new HttpSessionManager();
    }

    @Bean
    protected KeycloakLogoutHandler keycloakLogoutHandler() {
        return new KeycloakLogoutHandler(this.adapterDeploymentContextBean());
    }

    protected abstract SessionAuthenticationStrategy sessionAuthenticationStrategy();

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)http.sessionManagement().sessionAuthenticationStrategy(this.sessionAuthenticationStrategy()).and()).addFilterBefore((Filter)this.keycloakPreAuthActionsFilter(), LogoutFilter.class).addFilterBefore((Filter)this.keycloakAuthenticationProcessingFilter(), X509AuthenticationFilter.class).exceptionHandling().authenticationEntryPoint(this.authenticationEntryPoint());
    }
}

