/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.client;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.springframework.context.annotation.Scope;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class KeycloakClientRequestFactory
extends HttpComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory {
    public static final String AUTHORIZATION_HEADER = "Authorization";

    public KeycloakClientRequestFactory() {
        super((HttpClient)HttpClients.custom().disableCookieManagement().build());
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)authentication;
        KeycloakSecurityContext context = token.getAccount().getKeycloakSecurityContext();
        request.setHeader(AUTHORIZATION_HEADER, "Bearer " + context.getTokenString());
    }
}

