/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springboot;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.WebResourceCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.jetty.KeycloakJettyAuthenticator;
import org.keycloak.adapters.springboot.KeycloakSpringBootConfigResolver;
import org.keycloak.adapters.springboot.KeycloakSpringBootProperties;
import org.keycloak.adapters.tomcat.KeycloakAuthenticatorValve;
import org.keycloak.adapters.undertow.KeycloakServletExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={KeycloakSpringBootProperties.class})
public class KeycloakSpringBootConfiguration {
    private KeycloakSpringBootProperties keycloakProperties;

    @Autowired
    public void setKeycloakSpringBootProperties(KeycloakSpringBootProperties keycloakProperties) {
        this.keycloakProperties = keycloakProperties;
        KeycloakSpringBootConfigResolver.setAdapterConfig(keycloakProperties);
    }

    @Bean
    public EmbeddedServletContainerCustomizer getKeycloakContainerCustomizer() {
        return new EmbeddedServletContainerCustomizer(){

            public void customize(ConfigurableEmbeddedServletContainer configurableEmbeddedServletContainer) {
                if (configurableEmbeddedServletContainer instanceof TomcatEmbeddedServletContainerFactory) {
                    TomcatEmbeddedServletContainerFactory container = (TomcatEmbeddedServletContainerFactory)configurableEmbeddedServletContainer;
                    container.addContextValves(new Valve[]{new KeycloakAuthenticatorValve()});
                    container.addContextCustomizers(new TomcatContextCustomizer[]{KeycloakSpringBootConfiguration.this.tomcatKeycloakContextCustomizer()});
                } else if (configurableEmbeddedServletContainer instanceof UndertowEmbeddedServletContainerFactory) {
                    UndertowEmbeddedServletContainerFactory container = (UndertowEmbeddedServletContainerFactory)configurableEmbeddedServletContainer;
                    container.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{KeycloakSpringBootConfiguration.this.undertowKeycloakContextCustomizer()});
                } else if (configurableEmbeddedServletContainer instanceof JettyEmbeddedServletContainerFactory) {
                    JettyEmbeddedServletContainerFactory container = (JettyEmbeddedServletContainerFactory)configurableEmbeddedServletContainer;
                    container.addServerCustomizers(new JettyServerCustomizer[]{KeycloakSpringBootConfiguration.this.jettyKeycloakServerCustomizer()});
                }
            }
        };
    }

    @Bean
    @ConditionalOnClass(name={"org.eclipse.jetty.webapp.WebAppContext"})
    public JettyServerCustomizer jettyKeycloakServerCustomizer() {
        return new KeycloakJettyServerCustomizer(this.keycloakProperties);
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.catalina.startup.Tomcat"})
    public TomcatContextCustomizer tomcatKeycloakContextCustomizer() {
        return new KeycloakTomcatContextCustomizer(this.keycloakProperties);
    }

    @Bean
    @ConditionalOnClass(name={"io.undertow.Undertow"})
    public UndertowDeploymentInfoCustomizer undertowKeycloakContextCustomizer() {
        return new KeycloakUndertowDeploymentInfoCustomizer(this.keycloakProperties);
    }

    static class KeycloakTomcatContextCustomizer
    implements TomcatContextCustomizer {
        private final KeycloakSpringBootProperties keycloakProperties;

        public KeycloakTomcatContextCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            this.keycloakProperties = keycloakProperties;
        }

        public void customize(Context context) {
            org.apache.tomcat.util.descriptor.web.LoginConfig loginConfig = new org.apache.tomcat.util.descriptor.web.LoginConfig();
            loginConfig.setAuthMethod("KEYCLOAK");
            context.setLoginConfig(loginConfig);
            HashSet<String> authRoles = new HashSet<String>();
            for (KeycloakSpringBootProperties.SecurityConstraint constraint : this.keycloakProperties.getSecurityConstraints()) {
                for (KeycloakSpringBootProperties.SecurityCollection collection : constraint.getSecurityCollections()) {
                    for (String authRole : collection.getAuthRoles()) {
                        if (authRoles.contains(authRole)) continue;
                        context.addSecurityRole(authRole);
                        authRoles.add(authRole);
                    }
                }
            }
            for (KeycloakSpringBootProperties.SecurityConstraint constraint : this.keycloakProperties.getSecurityConstraints()) {
                org.apache.tomcat.util.descriptor.web.SecurityConstraint tomcatConstraint = new org.apache.tomcat.util.descriptor.web.SecurityConstraint();
                for (KeycloakSpringBootProperties.SecurityCollection collection : constraint.getSecurityCollections()) {
                    SecurityCollection tomcatSecCollection = new SecurityCollection();
                    if (collection.getName() != null) {
                        tomcatSecCollection.setName(collection.getName());
                    }
                    if (collection.getDescription() != null) {
                        tomcatSecCollection.setDescription(collection.getDescription());
                    }
                    for (String authRole : collection.getAuthRoles()) {
                        tomcatConstraint.addAuthRole(authRole);
                    }
                    for (String pattern : collection.getPatterns()) {
                        tomcatSecCollection.addPattern(pattern);
                    }
                    for (String method : collection.getMethods()) {
                        tomcatSecCollection.addMethod(method);
                    }
                    for (String method : collection.getOmittedMethods()) {
                        tomcatSecCollection.addOmittedMethod(method);
                    }
                    tomcatConstraint.addCollection(tomcatSecCollection);
                }
                context.addConstraint(tomcatConstraint);
            }
            context.addParameter("keycloak.config.resolver", KeycloakSpringBootConfigResolver.class.getName());
        }
    }

    static class KeycloakJettyServerCustomizer
    implements JettyServerCustomizer {
        private final KeycloakSpringBootProperties keycloakProperties;

        public KeycloakJettyServerCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            this.keycloakProperties = keycloakProperties;
        }

        public void customize(Server server) {
            KeycloakJettyAuthenticator keycloakJettyAuthenticator = new KeycloakJettyAuthenticator();
            keycloakJettyAuthenticator.setConfigResolver((KeycloakConfigResolver)new KeycloakSpringBootConfigResolver());
            ArrayList<ConstraintMapping> jettyConstraintMappings = new ArrayList<ConstraintMapping>();
            for (KeycloakSpringBootProperties.SecurityConstraint constraintDefinition : this.keycloakProperties.getSecurityConstraints()) {
                for (KeycloakSpringBootProperties.SecurityCollection securityCollectionDefinition : constraintDefinition.getSecurityCollections()) {
                    Constraint jettyConstraint = new Constraint();
                    jettyConstraint.setName(securityCollectionDefinition.getName());
                    jettyConstraint.setAuthenticate(true);
                    if (securityCollectionDefinition.getName() != null) {
                        jettyConstraint.setName(securityCollectionDefinition.getName());
                    }
                    jettyConstraint.setRoles(securityCollectionDefinition.getAuthRoles().toArray(new String[0]));
                    ConstraintMapping jettyConstraintMapping = new ConstraintMapping();
                    if (securityCollectionDefinition.getPatterns().size() > 0) {
                        jettyConstraintMapping.setPathSpec(securityCollectionDefinition.getPatterns().get(0));
                        jettyConstraintMapping.setConstraint(jettyConstraint);
                    }
                    if (securityCollectionDefinition.getMethods().size() > 0) {
                        jettyConstraintMapping.setMethod(securityCollectionDefinition.getMethods().get(0));
                    }
                    jettyConstraintMapping.setMethodOmissions(securityCollectionDefinition.getOmittedMethods().toArray(new String[0]));
                    jettyConstraintMappings.add(jettyConstraintMapping);
                }
            }
            WebAppContext webAppContext = (WebAppContext)server.getBean(WebAppContext.class);
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            securityHandler.setConstraintMappings(jettyConstraintMappings);
            securityHandler.setAuthenticator((Authenticator)keycloakJettyAuthenticator);
            webAppContext.setHandler((Handler)securityHandler);
        }
    }

    static class KeycloakUndertowDeploymentInfoCustomizer
    implements UndertowDeploymentInfoCustomizer {
        private final KeycloakSpringBootProperties keycloakProperties;

        public KeycloakUndertowDeploymentInfoCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            this.keycloakProperties = keycloakProperties;
        }

        public void customize(DeploymentInfo deploymentInfo) {
            LoginConfig loginConfig = new LoginConfig(this.keycloakProperties.getRealm());
            loginConfig.addFirstAuthMethod("KEYCLOAK");
            deploymentInfo.setLoginConfig(loginConfig);
            deploymentInfo.addInitParameter("keycloak.config.resolver", KeycloakSpringBootConfigResolver.class.getName());
            deploymentInfo.addSecurityConstraints(this.getSecurityConstraints());
            deploymentInfo.addServletExtension((ServletExtension)new KeycloakServletExtension());
        }

        private List<SecurityConstraint> getSecurityConstraints() {
            ArrayList<SecurityConstraint> undertowSecurityConstraints = new ArrayList<SecurityConstraint>();
            for (KeycloakSpringBootProperties.SecurityConstraint constraintDefinition : this.keycloakProperties.getSecurityConstraints()) {
                for (KeycloakSpringBootProperties.SecurityCollection collectionDefinition : constraintDefinition.getSecurityCollections()) {
                    SecurityConstraint undertowSecurityConstraint = new SecurityConstraint();
                    undertowSecurityConstraint.addRolesAllowed(collectionDefinition.getAuthRoles());
                    WebResourceCollection webResourceCollection = new WebResourceCollection();
                    webResourceCollection.addHttpMethods(collectionDefinition.getMethods());
                    webResourceCollection.addHttpMethodOmissions(collectionDefinition.getOmittedMethods());
                    webResourceCollection.addUrlPatterns(collectionDefinition.getPatterns());
                    undertowSecurityConstraint.addWebResourceCollections(new WebResourceCollection[]{webResourceCollection});
                    undertowSecurityConstraints.add(undertowSecurityConstraint);
                }
            }
            return undertowSecurityConstraints;
        }
    }
}

