/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springboot;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.WebResourceCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.catalina.Context;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.jetty.KeycloakJettyAuthenticator;
import org.keycloak.adapters.springboot.KeycloakSpringBootConfigResolver;
import org.keycloak.adapters.springboot.KeycloakSpringBootProperties;
import org.keycloak.adapters.undertow.KeycloakServletExtension;
import org.springframework.beans.factory.annotation.Autowired;

public class KeycloakBaseSpringBootConfiguration {
    protected KeycloakSpringBootProperties keycloakProperties;

    @Autowired
    public void setKeycloakSpringBootProperties(KeycloakSpringBootProperties keycloakProperties) {
        this.keycloakProperties = keycloakProperties;
        KeycloakSpringBootConfigResolver.setAdapterConfig(keycloakProperties);
    }

    static class KeycloakBaseTomcatContextCustomizer {
        protected final KeycloakSpringBootProperties keycloakProperties;

        public KeycloakBaseTomcatContextCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            this.keycloakProperties = keycloakProperties;
        }

        public void customize(Context context) {
            org.apache.tomcat.util.descriptor.web.LoginConfig loginConfig = new org.apache.tomcat.util.descriptor.web.LoginConfig();
            loginConfig.setAuthMethod("KEYCLOAK");
            context.setLoginConfig(loginConfig);
            HashSet<String> authRoles = new HashSet<String>();
            for (KeycloakSpringBootProperties.SecurityConstraint constraint : this.keycloakProperties.getSecurityConstraints()) {
                for (String authRole : constraint.getAuthRoles()) {
                    if (authRoles.contains(authRole)) continue;
                    context.addSecurityRole(authRole);
                    authRoles.add(authRole);
                }
            }
            for (KeycloakSpringBootProperties.SecurityConstraint constraint : this.keycloakProperties.getSecurityConstraints()) {
                org.apache.tomcat.util.descriptor.web.SecurityConstraint tomcatConstraint = new org.apache.tomcat.util.descriptor.web.SecurityConstraint();
                for (String authRole : constraint.getAuthRoles()) {
                    tomcatConstraint.addAuthRole(authRole);
                    if (!authRole.equals("*") && !authRole.equals("**")) continue;
                    tomcatConstraint.setAuthConstraint(true);
                }
                for (KeycloakSpringBootProperties.SecurityCollection collection : constraint.getSecurityCollections()) {
                    SecurityCollection tomcatSecCollection = new SecurityCollection();
                    if (collection.getName() != null) {
                        tomcatSecCollection.setName(collection.getName());
                    }
                    if (collection.getDescription() != null) {
                        tomcatSecCollection.setDescription(collection.getDescription());
                    }
                    for (String pattern : collection.getPatterns()) {
                        tomcatSecCollection.addPattern(pattern);
                    }
                    for (String method : collection.getMethods()) {
                        tomcatSecCollection.addMethod(method);
                    }
                    for (String method : collection.getOmittedMethods()) {
                        tomcatSecCollection.addOmittedMethod(method);
                    }
                    tomcatConstraint.addCollection(tomcatSecCollection);
                }
                context.addConstraint(tomcatConstraint);
            }
            context.addParameter("keycloak.config.resolver", KeycloakSpringBootConfigResolver.class.getName());
        }
    }

    static class KeycloakBaseJettyServerCustomizer {
        protected final KeycloakSpringBootProperties keycloakProperties;

        public KeycloakBaseJettyServerCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            this.keycloakProperties = keycloakProperties;
        }

        public void customize(Server server) {
            KeycloakJettyAuthenticator keycloakJettyAuthenticator = new KeycloakJettyAuthenticator();
            keycloakJettyAuthenticator.setConfigResolver((KeycloakConfigResolver)new KeycloakSpringBootConfigResolver());
            ArrayList<ConstraintMapping> jettyConstraintMappings = new ArrayList<ConstraintMapping>();
            for (KeycloakSpringBootProperties.SecurityConstraint constraintDefinition : this.keycloakProperties.getSecurityConstraints()) {
                for (KeycloakSpringBootProperties.SecurityCollection securityCollectionDefinition : constraintDefinition.getSecurityCollections()) {
                    Constraint jettyConstraint = new Constraint();
                    if (constraintDefinition.getAuthRoles().size() > 0) {
                        jettyConstraint.setAuthenticate(true);
                        jettyConstraint.setRoles(constraintDefinition.getAuthRoles().toArray(new String[0]));
                    }
                    jettyConstraint.setName(securityCollectionDefinition.getName());
                    for (String pattern : securityCollectionDefinition.getPatterns()) {
                        ConstraintMapping jettyConstraintMapping;
                        if (securityCollectionDefinition.getMethods().size() > 0) {
                            for (String method : securityCollectionDefinition.getMethods()) {
                                ConstraintMapping jettyConstraintMapping2 = new ConstraintMapping();
                                jettyConstraintMappings.add(jettyConstraintMapping2);
                                jettyConstraintMapping2.setConstraint(jettyConstraint);
                                jettyConstraintMapping2.setPathSpec(pattern);
                                jettyConstraintMapping2.setMethod(method);
                            }
                            continue;
                        }
                        if (securityCollectionDefinition.getOmittedMethods().size() > 0) {
                            jettyConstraintMapping = new ConstraintMapping();
                            jettyConstraintMappings.add(jettyConstraintMapping);
                            jettyConstraintMapping.setConstraint(jettyConstraint);
                            jettyConstraintMapping.setPathSpec(pattern);
                            jettyConstraintMapping.setMethodOmissions(securityCollectionDefinition.getOmittedMethods().toArray(new String[0]));
                            continue;
                        }
                        jettyConstraintMapping = new ConstraintMapping();
                        jettyConstraintMappings.add(jettyConstraintMapping);
                        jettyConstraintMapping.setConstraint(jettyConstraint);
                        jettyConstraintMapping.setPathSpec(pattern);
                    }
                }
            }
            WebAppContext webAppContext = (WebAppContext)server.getBean(WebAppContext.class);
            if (webAppContext == null) {
                webAppContext = (WebAppContext)server.getHandler();
            }
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            securityHandler.setConstraintMappings(jettyConstraintMappings);
            securityHandler.setAuthenticator((Authenticator)keycloakJettyAuthenticator);
            webAppContext.setSecurityHandler((SecurityHandler)securityHandler);
        }
    }

    static class KeycloakBaseUndertowDeploymentInfoCustomizer {
        protected final KeycloakSpringBootProperties keycloakProperties;

        public KeycloakBaseUndertowDeploymentInfoCustomizer(KeycloakSpringBootProperties keycloakProperties) {
            this.keycloakProperties = keycloakProperties;
        }

        public void customize(DeploymentInfo deploymentInfo) {
            LoginConfig loginConfig = new LoginConfig(this.keycloakProperties.getRealm());
            loginConfig.addFirstAuthMethod("KEYCLOAK");
            deploymentInfo.setLoginConfig(loginConfig);
            deploymentInfo.addInitParameter("keycloak.config.resolver", KeycloakSpringBootConfigResolver.class.getName());
            deploymentInfo.addSecurityConstraints(this.getSecurityConstraints());
            deploymentInfo.addServletExtension((ServletExtension)new KeycloakServletExtension());
        }

        private List<SecurityConstraint> getSecurityConstraints() {
            ArrayList<SecurityConstraint> undertowSecurityConstraints = new ArrayList<SecurityConstraint>();
            for (KeycloakSpringBootProperties.SecurityConstraint constraintDefinition : this.keycloakProperties.getSecurityConstraints()) {
                SecurityConstraint undertowSecurityConstraint = new SecurityConstraint();
                undertowSecurityConstraint.addRolesAllowed(constraintDefinition.getAuthRoles());
                for (KeycloakSpringBootProperties.SecurityCollection collectionDefinition : constraintDefinition.getSecurityCollections()) {
                    WebResourceCollection webResourceCollection = new WebResourceCollection();
                    webResourceCollection.addHttpMethods(collectionDefinition.getMethods());
                    webResourceCollection.addHttpMethodOmissions(collectionDefinition.getOmittedMethods());
                    webResourceCollection.addUrlPatterns(collectionDefinition.getPatterns());
                    undertowSecurityConstraint.addWebResourceCollections(new WebResourceCollection[]{webResourceCollection});
                }
                undertowSecurityConstraints.add(undertowSecurityConstraint);
            }
            return undertowSecurityConstraints;
        }
    }
}

