/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.servlet;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.HttpClient;
import org.keycloak.adapters.HttpClientBuilder;
import org.keycloak.enums.RelativeUrlsUsed;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.servlet.ServletOAuthClient;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.KeycloakUriBuilder;

public class ServletOAuthClientBuilder {
    public static ServletOAuthClient build(InputStream is) {
        AdapterConfig adapterConfig = ServletOAuthClientBuilder.getAdapterConfig(is);
        return ServletOAuthClientBuilder.build(adapterConfig);
    }

    public static AdapterConfig getAdapterConfig(InputStream is) {
        try {
            return (AdapterConfig)JsonSerialization.readValue((InputStream)is, AdapterConfig.class, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServletOAuthClient build(AdapterConfig adapterConfig) {
        ServletOAuthClient oauthClient = new ServletOAuthClient();
        ServletOAuthClientBuilder.build(adapterConfig, oauthClient);
        return oauthClient;
    }

    public static void build(InputStream is, ServletOAuthClient oauthClient) {
        ServletOAuthClientBuilder.build(ServletOAuthClientBuilder.getAdapterConfig(is), oauthClient);
    }

    public static void build(AdapterConfig adapterConfig, ServletOAuthClient oauthClient) {
        KeycloakUriBuilder tokenUrlBuilder;
        HttpClient client = new HttpClientBuilder().build(adapterConfig);
        oauthClient.setClient(client);
        oauthClient.setClientId(adapterConfig.getResource());
        oauthClient.setPublicClient(adapterConfig.isPublicClient());
        oauthClient.setCredentials(adapterConfig.getCredentials());
        if (adapterConfig.getAuthServerUrl() == null) {
            throw new RuntimeException("You must specify auth-url");
        }
        KeycloakUriBuilder serverBuilder = KeycloakUriBuilder.fromUri((String)adapterConfig.getAuthServerUrl());
        RelativeUrlsUsed useRelative = ServletOAuthClientBuilder.relativeUrls(serverBuilder, adapterConfig);
        oauthClient.setRelativeUrlsUsed(useRelative);
        String authUrl = serverBuilder.clone().path("/realms/{realm-name}/protocol/openid-connect/auth").build(new Object[]{adapterConfig.getRealm()}).toString();
        if (useRelative == RelativeUrlsUsed.BROWSER_ONLY) {
            KeycloakUriBuilder nonBrowsersServerBuilder = KeycloakUriBuilder.fromUri((String)adapterConfig.getAuthServerUrlForBackendRequests());
            tokenUrlBuilder = nonBrowsersServerBuilder.clone();
        } else {
            tokenUrlBuilder = serverBuilder.clone();
        }
        String tokenUrl = tokenUrlBuilder.path("/realms/{realm-name}/protocol/openid-connect/token").build(new Object[]{adapterConfig.getRealm()}).toString();
        oauthClient.setAuthUrl(authUrl);
        oauthClient.setTokenUrl(tokenUrl);
    }

    private static RelativeUrlsUsed relativeUrls(KeycloakUriBuilder serverBuilder, AdapterConfig adapterConfig) {
        if (serverBuilder.clone().getHost() == null) {
            return adapterConfig.getAuthServerUrlForBackendRequests() != null ? RelativeUrlsUsed.BROWSER_ONLY : RelativeUrlsUsed.ALL_REQUESTS;
        }
        return RelativeUrlsUsed.NEVER;
    }
}

