/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.ResourceWrapper;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.services.resources.admin.permissions.GroupPermissions;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;

class GroupPermissionsV2
extends GroupPermissions {
    private final KeycloakSession session;

    GroupPermissionsV2(KeycloakSession session, AuthorizationProvider authz, MgmtPermissions root) {
        super(authz, root);
        this.session = session;
    }

    @Override
    public boolean canView() {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS, AdminRoles.VIEW_USERS)) {
            return true;
        }
        return this.hasPermission(null, "view");
    }

    @Override
    public boolean canView(GroupModel group) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS, AdminRoles.VIEW_USERS)) {
            return true;
        }
        return this.hasPermission(group.getId(), "view");
    }

    @Override
    public boolean canManage() {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(null, "manage");
    }

    @Override
    public boolean canManage(GroupModel group) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(group.getId(), "manage");
    }

    @Override
    public boolean canViewMembers(GroupModel group) {
        if (this.root.hasOneAdminRole(AdminRoles.VIEW_USERS, AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(group.getId(), "view-members");
    }

    @Override
    public boolean canManageMembers(GroupModel group) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(group.getId(), "manage-members");
    }

    @Override
    public boolean canManageMembership(GroupModel group) {
        if (this.root.hasOneAdminRole(AdminRoles.MANAGE_USERS)) {
            return true;
        }
        return this.hasPermission(group.getId(), "manage-membership");
    }

    @Override
    public Set<String> getGroupIdsWithViewPermission() {
        if (this.root.hasOneAdminRole(AdminRoles.VIEW_USERS, AdminRoles.MANAGE_USERS)) {
            return Collections.emptySet();
        }
        if (!this.root.isAdminSameRealm()) {
            return Collections.emptySet();
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return Collections.emptySet();
        }
        HashSet<String> granted = new HashSet<String>();
        this.policyStore.findByResourceType(server, "Groups").stream().flatMap(policy -> policy.getResources().stream()).forEach(gr -> {
            if (this.hasPermission(gr.getName(), "view-members", "manage-members")) {
                granted.add(gr.getName());
            }
        });
        return granted;
    }

    private boolean hasPermission(String groupId, String ... scopes) {
        return this.hasPermission(groupId, (EvaluationContext)null, scopes);
    }

    private boolean hasPermission(String groupId, EvaluationContext context, String ... scopes) {
        Resource resource;
        if (!this.root.isAdminSameRealm()) {
            return false;
        }
        ResourceServer server = this.root.realmResourceServer();
        if (server == null) {
            return false;
        }
        String resourceType = "Groups";
        Resource resourceTypeResource = AdminPermissionsSchema.SCHEMA.getResourceTypeResource(this.session, server, resourceType);
        Resource resource2 = resource = groupId == null ? resourceTypeResource : this.resourceStore.findByName(server, groupId);
        if (groupId != null && resource == null) {
            resource = new ResourceWrapper(groupId, groupId, new HashSet(resourceTypeResource.getScopes()), server);
        }
        Collection<Permission> permissions = context == null ? this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server) : this.root.evaluatePermission(new ResourcePermission(resourceType, resource, (Collection)resource.getScopes(), server), server, context);
        List<String> expectedScopes = List.of(scopes);
        for (Permission permission : permissions) {
            if (!permission.getResourceId().equals(resource.getId())) continue;
            for (String scope : permission.getScopes()) {
                if (!expectedScopes.contains(scope)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPermissionsEnabled(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(GroupModel group, boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewMembersPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageMembersPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageMembershipPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewPermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy managePermission(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions(GroupModel group) {
        throw new UnsupportedOperationException("Not supported in V2");
    }
}

