/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleResource;

public class RoleByIdResource
extends RoleResource {
    protected static final Logger logger = Logger.getLogger(RoleByIdResource.class);
    private final RealmModel realm;
    private final RealmAuth auth;
    private AdminEventBuilder adminEvent;
    @Context
    private KeycloakSession session;
    @Context
    private UriInfo uriInfo;

    public RoleByIdResource(RealmModel realm, RealmAuth auth, AdminEventBuilder adminEvent) {
        super(realm);
        this.realm = realm;
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    @Path(value="{role-id}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RoleRepresentation getRole(@PathParam(value="role-id") String id) {
        RoleModel roleModel = this.getRoleModel(id);
        this.auth.requireView();
        return this.getRole(roleModel);
    }

    protected RoleModel getRoleModel(String id) {
        RoleModel roleModel = this.realm.getRoleById(id);
        if (roleModel == null) {
            throw new NotFoundException("Could not find role with id: " + id);
        }
        RealmAuth.Resource r = null;
        if (roleModel.getContainer() instanceof RealmModel) {
            r = RealmAuth.Resource.REALM;
        } else if (roleModel.getContainer() instanceof ClientModel) {
            r = RealmAuth.Resource.CLIENT;
        } else if (roleModel.getContainer() instanceof UserModel) {
            r = RealmAuth.Resource.USER;
        }
        this.auth.init(r);
        return roleModel;
    }

    @Path(value="{role-id}")
    @DELETE
    @NoCache
    public void deleteRole(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        this.auth.requireManage();
        this.deleteRole(role);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).success();
    }

    @Path(value="{role-id}")
    @PUT
    @Consumes(value={"application/json"})
    public void updateRole(@PathParam(value="role-id") String id, RoleRepresentation rep) {
        RoleModel role = this.getRoleModel(id);
        this.auth.requireManage();
        this.updateRole(rep, role);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath(this.uriInfo).representation(rep).success();
    }

    @Path(value="{role-id}/composites")
    @POST
    @Consumes(value={"application/json"})
    public void addComposites(@PathParam(value="role-id") String id, List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.auth.requireManage();
        this.addComposites(this.adminEvent, this.uriInfo, roles, role);
    }

    @Path(value="{role-id}/composites")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites(@PathParam(value="role-id") String id) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*** getRoleComposites: '" + id + "'"));
        }
        RoleModel role = this.getRoleModel(id);
        this.auth.requireView();
        return this.getRoleComposites(role);
    }

    @Path(value="{role-id}/composites/realm")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites(@PathParam(value="role-id") String id) {
        RoleModel role = this.getRoleModel(id);
        this.auth.requireView();
        return this.getRealmRoleComposites(role);
    }

    @Path(value="{role-id}/composites/clients/{client}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getClientRoleComposites(@PathParam(value="role-id") String id, @PathParam(value="client") String client) {
        RoleModel role = this.getRoleModel(id);
        this.auth.requireView();
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client: " + client);
        }
        return this.getClientRoleComposites(clientModel, role);
    }

    @Path(value="{role}/composites/clients/{client}")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getClientByIdRoleComposites(@PathParam(value="role-id") String role, @PathParam(value="client") String client) {
        RoleModel roleModel = this.getRoleModel(role);
        this.auth.requireView();
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client: " + client);
        }
        return this.getClientRoleComposites(clientModel, roleModel);
    }

    @Path(value="{role-id}/composites")
    @DELETE
    @Consumes(value={"application/json"})
    public void deleteComposites(@PathParam(value="role-id") String id, List<RoleRepresentation> roles) {
        RoleModel role = this.getRoleModel(id);
        this.auth.requireManage();
        this.deleteComposites(roles, role);
        this.adminEvent.operation(OperationType.DELETE).resourcePath(this.uriInfo).representation(roles).success();
    }
}

