/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import org.keycloak.models.ClientTemplateModel;
import org.keycloak.saml.SignatureAlgorithm;

public class SamlClientTemplate {
    protected ClientTemplateModel clientTemplate;

    public SamlClientTemplate(ClientTemplateModel template) {
        this.clientTemplate = template;
    }

    public String getId() {
        return this.clientTemplate.getId();
    }

    public String getCanonicalizationMethod() {
        return this.clientTemplate.getAttribute("saml_signature_canonicalization_method");
    }

    public void setCanonicalizationMethod(String value) {
        this.clientTemplate.setAttribute("saml_signature_canonicalization_method", value);
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        SignatureAlgorithm algorithm;
        String alg = null;
        alg = this.clientTemplate.getAttribute("saml_signature_canonicalization_method");
        if (alg != null && (algorithm = SignatureAlgorithm.valueOf((String)alg)) != null) {
            return algorithm;
        }
        return SignatureAlgorithm.RSA_SHA256;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm algorithm) {
        this.clientTemplate.setAttribute("saml.signature.algorithm", algorithm.name());
    }

    public String getNameIDFormat() {
        return (String)this.clientTemplate.getAttributes().get("saml_name_id_format");
    }

    public void setNameIDFormat(String format) {
        this.clientTemplate.setAttribute("saml_name_id_format", format);
    }

    public boolean includeAuthnStatement() {
        return "true".equals(this.clientTemplate.getAttribute("saml.authnstatement"));
    }

    public void setIncludeAuthnStatement(boolean val) {
        this.clientTemplate.setAttribute("saml.authnstatement", Boolean.toString(val));
    }

    public boolean forceNameIDFormat() {
        return "true".equals(this.clientTemplate.getAttribute("saml_force_name_id_format"));
    }

    public void setForceNameIDFormat(boolean val) {
        this.clientTemplate.setAttribute("saml_force_name_id_format", Boolean.toString(val));
    }

    public boolean requiresRealmSignature() {
        return "true".equals(this.clientTemplate.getAttribute("saml.server.signature"));
    }

    public void setRequiresRealmSignature(boolean val) {
        this.clientTemplate.setAttribute("saml.server.signature", Boolean.toString(val));
    }

    public boolean forcePostBinding() {
        return "true".equals(this.clientTemplate.getAttribute("saml.force.post.binding"));
    }

    public void setForcePostBinding(boolean val) {
        this.clientTemplate.setAttribute("saml.force.post.binding", Boolean.toString(val));
    }

    public boolean requiresAssertionSignature() {
        return "true".equals(this.clientTemplate.getAttribute("saml.assertion.signature"));
    }

    public void setRequiresAssertionSignature(boolean val) {
        this.clientTemplate.setAttribute("saml.assertion.signature", Boolean.toString(val));
    }

    public boolean requiresEncryption() {
        return "true".equals(this.clientTemplate.getAttribute("saml.encrypt"));
    }

    public void setRequiresEncryption(boolean val) {
        this.clientTemplate.setAttribute("saml.encrypt", Boolean.toString(val));
    }

    public boolean requiresClientSignature() {
        return "true".equals(this.clientTemplate.getAttribute("saml.client.signature"));
    }

    public void setRequiresClientSignature(boolean val) {
        this.clientTemplate.setAttribute("saml.client.signature", Boolean.toString(val));
    }

    public String getClientSigningCertificate() {
        return this.clientTemplate.getAttribute("saml.signing.certificate");
    }

    public void setClientSigningCertificate(String val) {
        this.clientTemplate.setAttribute("saml.signing.certificate", val);
    }

    public String getClientSigningPrivateKey() {
        return this.clientTemplate.getAttribute("saml.signing.private.key");
    }

    public void setClientSigningPrivateKey(String val) {
        this.clientTemplate.setAttribute("saml.signing.private.key", val);
    }
}

