/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.protocol.saml.SAML2BindingBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.keycloak.saml.processing.core.saml.v2.holders.IDPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.IssuerInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.SPInfoHolder;
import org.w3c.dom.Document;

public class SAML2ErrorResponseBuilder
extends SAML2BindingBuilder<SAML2ErrorResponseBuilder> {
    protected String status;

    public SAML2ErrorResponseBuilder status(String status) {
        this.status = status;
        return this;
    }

    public SAML2BindingBuilder.RedirectBindingBuilder redirectBinding() throws ConfigurationException, ProcessingException {
        Document samlResponseDocument = this.buildDocument();
        return new SAML2BindingBuilder.RedirectBindingBuilder(samlResponseDocument);
    }

    public SAML2BindingBuilder.PostBindingBuilder postBinding() throws ConfigurationException, ProcessingException {
        Document samlResponseDocument = this.buildDocument();
        return new SAML2BindingBuilder.PostBindingBuilder(samlResponseDocument);
    }

    public Document buildDocument() throws ProcessingException {
        Document samlResponse = null;
        ResponseType responseType = null;
        SAML2Response saml2Response = new SAML2Response();
        String id = IDGenerator.create((String)"ID_");
        IssuerInfoHolder issuerHolder = new IssuerInfoHolder(this.issuer);
        issuerHolder.setStatusCode(this.status);
        IDPInfoHolder idp = new IDPInfoHolder();
        idp.setNameIDFormatValue(null);
        idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
        SPInfoHolder sp = new SPInfoHolder();
        sp.setResponseDestinationURI(this.destination);
        responseType = saml2Response.createResponseType(id);
        responseType.setStatus(JBossSAMLAuthnResponseFactory.createStatusTypeForResponder((String)this.status));
        responseType.setDestination(this.destination);
        if (this.encrypt) {
            this.encryptDocument(samlResponse);
        }
        return samlResponse;
    }
}

