/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.util.StatementUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.w3c.dom.Document;

public class SAML2LoginResponseBuilder {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected String destination;
    protected String issuer;
    protected int subjectExpiration;
    protected int assertionExpiration;
    protected String nameId;
    protected String nameIdFormat;
    protected boolean multiValuedRoles;
    protected boolean disableAuthnStatement;
    protected String requestID;
    protected String authMethod;
    protected String requestIssuer;
    protected String sessionIndex;

    public SAML2LoginResponseBuilder sessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
        return this;
    }

    public SAML2LoginResponseBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SAML2LoginResponseBuilder issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public SAML2LoginResponseBuilder subjectExpiration(int subjectExpiration) {
        this.subjectExpiration = subjectExpiration;
        return this;
    }

    public SAML2LoginResponseBuilder assertionExpiration(int assertionExpiration) {
        this.assertionExpiration = this.subjectExpiration;
        return this;
    }

    public SAML2LoginResponseBuilder requestID(String requestID) {
        this.requestID = requestID;
        return this;
    }

    public SAML2LoginResponseBuilder requestIssuer(String requestIssuer) {
        this.requestIssuer = requestIssuer;
        return this;
    }

    public SAML2LoginResponseBuilder authMethod(String authMethod) {
        this.authMethod = authMethod;
        return this;
    }

    public SAML2LoginResponseBuilder nameIdentifier(String nameIdFormat, String nameId) {
        this.nameIdFormat = nameIdFormat;
        this.nameId = nameId;
        return this;
    }

    public SAML2LoginResponseBuilder multiValuedRoles(boolean multiValuedRoles) {
        this.multiValuedRoles = multiValuedRoles;
        return this;
    }

    public SAML2LoginResponseBuilder disableAuthnStatement(boolean disableAuthnStatement) {
        this.disableAuthnStatement = disableAuthnStatement;
        return this;
    }

    public Document buildDocument(ResponseType responseType) throws ConfigurationException, ProcessingException {
        Document samlResponseDocument = null;
        try {
            SAML2Response docGen = new SAML2Response();
            samlResponseDocument = docGen.convert((StatusResponseType)responseType);
            if (logger.isTraceEnabled()) {
                logger.trace("SAML Response Document: " + DocumentUtil.asString((Document)samlResponseDocument));
            }
        }
        catch (Exception e) {
            throw logger.samlAssertionMarshallError((Throwable)e);
        }
        return samlResponseDocument;
    }

    public ResponseType buildModel() throws ConfigurationException, ProcessingException {
        ResponseType responseType = null;
        SAML2Response saml2Response = new SAML2Response();
        String id = IDGenerator.create((String)"ID_");
        IssuerInfoHolder issuerHolder = new IssuerInfoHolder(this.issuer);
        issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
        IDPInfoHolder idp = new IDPInfoHolder();
        idp.setNameIDFormatValue(this.nameId);
        idp.setNameIDFormat(this.nameIdFormat);
        SPInfoHolder sp = new SPInfoHolder();
        sp.setResponseDestinationURI(this.destination);
        sp.setRequestID(this.requestID);
        sp.setIssuer(this.requestIssuer);
        responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
        AssertionType assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
        if (this.assertionExpiration > 0) {
            ConditionsType conditions = assertion.getConditions();
            conditions.setNotOnOrAfter(XMLTimeUtil.add((XMLGregorianCalendar)conditions.getNotBefore(), (long)(this.assertionExpiration * 1000)));
        }
        if (this.subjectExpiration > 0) {
            SubjectConfirmationDataType subjectConfirmationData = ((SubjectConfirmationType)assertion.getSubject().getConfirmation().get(0)).getSubjectConfirmationData();
            subjectConfirmationData.setNotOnOrAfter(XMLTimeUtil.add((XMLGregorianCalendar)assertion.getConditions().getNotBefore(), (long)(this.subjectExpiration * 1000)));
        }
        if (!this.disableAuthnStatement) {
            String authContextRef = JBossSAMLURIConstants.AC_UNSPECIFIED.get();
            if (StringUtil.isNotNull((String)this.authMethod)) {
                authContextRef = this.authMethod;
            }
            AuthnStatementType authnStatement = StatementUtil.createAuthnStatement((XMLGregorianCalendar)XMLTimeUtil.getIssueInstant(), (String)authContextRef);
            if (this.sessionIndex != null) {
                authnStatement.setSessionIndex(this.sessionIndex);
            } else {
                authnStatement.setSessionIndex(assertion.getID());
            }
            assertion.addStatement((StatementAbstractType)authnStatement);
        }
        return responseType;
    }
}

